/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import net.thucydides.core.webdriver.SupportedWebDriver;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.AjaxElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;

public class WebDriverFactory {
    private static final int TIMEOUT = 120;

    public WebDriver newInstanceOf(SupportedWebDriver driverType) {
        if (driverType == null) {
            throw new IllegalArgumentException("Driver type cannot be null");
        }
        switch (driverType) {
            case FIREFOX: {
                return this.newFirefoxDriver();
            }
            case CHROME: {
                return this.newChromeDriver();
            }
        }
        throw new IllegalArgumentException((Object)((Object)driverType) + " support hasn't been implemented yet - this is a bug.");
    }

    protected WebDriver newChromeDriver() {
        return new ChromeDriver();
    }

    protected WebDriver newFirefoxDriver() {
        return new FirefoxDriver();
    }

    public static void initElementsWithAjaxSupport(Object pageObject, WebDriver driver) {
        AjaxElementLocatorFactory finder = new AjaxElementLocatorFactory(driver, 120);
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)pageObject);
    }
}

