/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.WebDriverFactory;
import org.openqa.selenium.WebDriver;

public class WebdriverManager {
    private WebDriverFactory webDriverFactory;
    private ThreadLocal<WebDriver> webdriver = new ThreadLocal();

    public WebdriverManager(WebDriverFactory webDriverFactory) {
        this.webDriverFactory = webDriverFactory;
        this.webdriver.set(this.newDriver());
    }

    protected WebDriver newDriver() {
        SupportedWebDriver supportedDriverType = Configuration.getDriverType();
        return this.webDriverFactory.newInstanceOf(supportedDriverType);
    }

    public void closeDriver() {
        if (this.webdriver != null && this.webdriver.get() != null) {
            this.webdriver.get().quit();
            this.webdriver.remove();
        }
    }

    public WebDriver getWebdriver() {
        return this.webdriver.get();
    }
}

