/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import net.thucydides.core.model.AcceptanceTestRun;
import net.thucydides.core.model.UserStory;
import net.thucydides.core.util.NameConverter;

public class ReportNamer {
    private ReportType type;

    public ReportNamer(ReportType type) {
        this.type = type;
    }

    public String getNormalizedTestNameFor(AcceptanceTestRun testRun) {
        String userStory = "";
        if (testRun.getUserStory() != null) {
            userStory = NameConverter.underscore(testRun.getUserStory().getName()) + "_";
        }
        return this.appendSuffixTo(userStory + testRun.getMethodName());
    }

    public String getNormalizedTestNameFor(UserStory userStory) {
        String testNameWithUnderscores = NameConverter.underscore(userStory.getName());
        return this.appendSuffixTo(testNameWithUnderscores);
    }

    private String appendSuffixTo(String testNameWithUnderscores) {
        if (this.type == ReportType.ROOT) {
            return testNameWithUnderscores;
        }
        return testNameWithUnderscores + "." + this.type.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReportType {
        ROOT(""),
        XML("xml"),
        HTML("html");

        private String suffix;

        private ReportType(String suffix) {
            this.suffix = suffix;
        }

        public String toString() {
            return this.suffix;
        }
    }
}

