/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.thucydides.core.model.UserStoryTestResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserStoriesResultSet {
    private final List<UserStoryTestResults> stories;

    public UserStoriesResultSet(List<UserStoryTestResults> stories) {
        this.stories = stories;
    }

    public List<UserStoryTestResults> getStories() {
        return ImmutableList.copyOf(this.stories);
    }

    public int getStoryCount() {
        return this.stories.size();
    }

    public int getAcceptanceTestCount() {
        int count = 0;
        for (UserStoryTestResults story : this.stories) {
            count += story.getTotal();
        }
        return count;
    }

    public int getSuccessCount() {
        int count = 0;
        for (UserStoryTestResults story : this.stories) {
            count += story.getSuccessCount();
        }
        return count;
    }

    public int getFailureCount() {
        int count = 0;
        for (UserStoryTestResults story : this.stories) {
            count += story.getFailureCount();
        }
        return count;
    }

    public int getPendingCount() {
        int count = 0;
        for (UserStoryTestResults story : this.stories) {
            count += story.getPendingCount().intValue();
        }
        return count;
    }
}

