/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.model.AcceptanceTestRun;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.UserStory;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserStoryTestResults {
    private List<AcceptanceTestRun> testRuns = new ArrayList<AcceptanceTestRun>();
    private final String title;
    private UserStory userStory;

    public UserStoryTestResults(UserStory someUserStory) {
        this.title = someUserStory.getName();
        this.userStory = someUserStory;
    }

    public UserStory getUserStory() {
        return this.userStory;
    }

    public void setUserStory(UserStory userStory) {
        this.userStory = userStory;
    }

    public String getReportName(ReportNamer.ReportType type) {
        ReportNamer reportNamer = new ReportNamer(type);
        return reportNamer.getNormalizedTestNameFor(this.getUserStory());
    }

    public String getReportName() {
        return this.getReportName(ReportNamer.ReportType.ROOT);
    }

    public void recordTestRun(AcceptanceTestRun testRun) {
        this.testRuns.add(testRun);
    }

    public int getTotal() {
        return this.testRuns.size();
    }

    public int getFailureCount() {
        return Lambda.select(this.testRuns, (Matcher)Lambda.having((Boolean)((AcceptanceTestRun)Lambda.on(AcceptanceTestRun.class)).isFailure())).size();
    }

    public int getSuccessCount() {
        return Lambda.select(this.testRuns, (Matcher)Lambda.having((Boolean)((AcceptanceTestRun)Lambda.on(AcceptanceTestRun.class)).isSuccess())).size();
    }

    public Integer getPendingCount() {
        return Lambda.select(this.testRuns, (Matcher)Lambda.having((Boolean)((AcceptanceTestRun)Lambda.on(AcceptanceTestRun.class)).isPending())).size();
    }

    public List<AcceptanceTestRun> getTestRuns() {
        return ImmutableList.copyOf(this.testRuns);
    }

    public String getTitle() {
        return this.title;
    }

    private List<TestResult> getCurrentTestResults() {
        return Lambda.convert(this.getTestRuns(), (Converter)new ExtractTestResultsConverter());
    }

    public TestResult getResult() {
        TestResultList testResults = new TestResultList(this.getCurrentTestResults());
        return testResults.getOverallResult();
    }

    public boolean containsResultsFor(UserStory aUserStory) {
        if (this.getUserStory() != null) {
            return this.getUserStory().equals(aUserStory);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractTestResultsConverter
    implements Converter<AcceptanceTestRun, TestResult> {
        private ExtractTestResultsConverter() {
        }

        public TestResult convert(AcceptanceTestRun step) {
            return step.getResult();
        }
    }
}

