/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.util.List;
import java.util.Set;
import net.thucydides.core.pages.MatchingPageExpressions;
import net.thucydides.core.pages.PageUrls;
import net.thucydides.core.pages.RenderedPageObjectView;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webelements.Checkbox;
import net.thucydides.core.webelements.MultipleSelect;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PageObject {
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 50;
    private static final int ONE_SECOND = 1000;
    private long waitForTimeout = 50L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PageObject.class);
    private static final long WAIT_FOR_TIMEOUT = 30000L;
    private WebDriver driver;
    private MatchingPageExpressions matchingPageExpressions;
    private RenderedPageObjectView renderedView;
    private PageUrls pageUrls;

    public PageObject(WebDriver driver) {
        this.driver = driver;
        this.waitForTimeout = 30000L;
        this.setupPageUrls();
        WebDriverFactory.initElementsWithAjaxSupport(this, driver);
    }

    private void setupPageUrls() {
        this.pageUrls = new PageUrls(this);
    }

    public void setWaitForTimeout(long waitForTimeout) {
        this.waitForTimeout = waitForTimeout;
    }

    private RenderedPageObjectView getRenderedView() {
        if (this.renderedView == null) {
            this.renderedView = new RenderedPageObjectView(this.driver, this.waitForTimeout);
        }
        return this.renderedView;
    }

    private MatchingPageExpressions getMatchingPageExpressions() {
        if (this.matchingPageExpressions == null) {
            this.matchingPageExpressions = new MatchingPageExpressions(this);
        }
        return this.matchingPageExpressions;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    public final boolean compatibleWithUrl(String currentUrl) {
        if (this.thereAreNoPatternsDefined()) {
            return true;
        }
        return this.matchUrlAgainstEachPattern(currentUrl);
    }

    private boolean matchUrlAgainstEachPattern(String currentUrl) {
        return this.getMatchingPageExpressions().matchUrlAgainstEachPattern(currentUrl);
    }

    private boolean thereAreNoPatternsDefined() {
        return this.getMatchingPageExpressions().isEmpty();
    }

    public PageObject waitForRenderedElements(By byElementCriteria) {
        this.getRenderedView().waitFor(byElementCriteria);
        return this;
    }

    public PageObject waitForRenderedElementsToDisappear(By byElementCriteria) {
        this.getRenderedView().waitForElementsToDisappear(byElementCriteria);
        return this;
    }

    public PageObject waitForTextToAppear(String expectedText) {
        this.getRenderedView().waitForText(expectedText);
        return this;
    }

    public PageObject waitForTextToAppear(WebElement element, String expectedText) {
        this.getRenderedView().waitForText(element, expectedText);
        return this;
    }

    public PageObject waitForTextToDisappear(String expectedText) {
        return this.waitForTextToDisappear(expectedText, this.waitForTimeout);
    }

    public PageObject waitForTextToDisappear(String expectedText, long timeout) {
        this.getRenderedView().waitForTextToDisappear(expectedText, timeout);
        return this;
    }

    public PageObject waitForAnyTextToAppear(String ... expectedText) {
        this.getRenderedView().waitForAnyTextToAppear(expectedText);
        return this;
    }

    public PageObject waitForAnyTextToAppear(WebElement element, String ... expectedText) {
        this.getRenderedView().waitForAnyTextToAppear(element, expectedText);
        return this;
    }

    public PageObject waitForAllTextToAppear(String ... expectedTexts) {
        this.getRenderedView().waitForAllTextToAppear(expectedTexts);
        return this;
    }

    protected void waitABit(long timeInMilliseconds) {
        try {
            Thread.sleep(timeInMilliseconds);
        }
        catch (InterruptedException e) {
            LOGGER.error("Wait interrupted", (Throwable)e);
        }
    }

    public List<WebElement> thenReturnElementList(By byListCriteria) {
        return this.driver.findElements(byListCriteria);
    }

    public void shouldContainText(String textValue) {
        if (!this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the page", textValue);
            throw new NoSuchElementException(errorMessage);
        }
    }

    public void typeInto(WebElement field, String value) {
        field.clear();
        field.sendKeys(new CharSequence[]{value});
    }

    public void selectFromDropdown(WebElement dropdown, String visibleLabel) {
        Select dropdownSelect = this.findSelectFor(dropdown);
        dropdownSelect.selectByVisibleText(visibleLabel);
    }

    public void selectMultipleItemsFromDropdown(WebElement dropdown, String ... selectedLabels) {
        for (String selectedLabel : selectedLabels) {
            String optionPath = String.format("//option[.='%s']", selectedLabel);
            WebElement option = dropdown.findElement(By.xpath((String)optionPath));
            option.click();
        }
    }

    public Set<String> getSelectedOptionLabelsFrom(WebElement dropdown) {
        MultipleSelect multipleSelect = new MultipleSelect(dropdown);
        return multipleSelect.getSelectedOptionLabels();
    }

    public Set<String> getSelectedOptionValuesFrom(WebElement dropdown) {
        MultipleSelect multipleSelect = new MultipleSelect(dropdown);
        return multipleSelect.getSelectedOptionValues();
    }

    public void setCheckbox(WebElement field, boolean value) {
        Checkbox checkbox = new Checkbox(field);
        checkbox.setChecked(value);
    }

    protected Select findSelectFor(WebElement dropdownList) {
        return new Select(dropdownList);
    }

    public boolean containsText(String textValue) {
        return this.getRenderedView().containsText(textValue);
    }

    public boolean userCanSee(WebElement field) {
        return this.getRenderedView().userCanSee(field);
    }

    public void shouldBeVisible(WebElement field) {
        if (!this.userCanSee(field)) {
            throw new AssertionError((Object)("The " + field + " element should be visible"));
        }
    }

    public void open() {
        String startingUrl = this.pageUrls.getStartingUrl();
        this.getDriver().get(startingUrl);
    }

    public void open(String ... parameterValues) {
        String startingUrl = this.pageUrls.getStartingUrl(parameterValues);
        this.getDriver().get(startingUrl);
    }

    public static String[] withParameters(String ... parameterValues) {
        return parameterValues;
    }

    public void open(String urlTemplateName, String[] parameterValues) {
        String startingUrl = this.pageUrls.getNamedUrl(urlTemplateName, parameterValues);
        this.getDriver().get(startingUrl);
    }

    public void clickOn(WebElement webElement) {
        try {
            webElement.click();
        }
        catch (WebDriverException e) {
            LOGGER.warn("Click failed. This could be a flicking failure, so I'll wait 1 second and try again", (Throwable)e);
            this.waitABit(1000L);
        }
        webElement.click();
    }

    public Boolean isElementVisible(By byCriteria) {
        return this.getRenderedView().elementIsDisplayed(byCriteria);
    }

    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.pageUrls.overrideDefaultBaseUrl(defaultBaseUrl);
    }
}

