/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import net.thucydides.core.model.AcceptanceTestRun;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.html.HtmlReporter;
import org.apache.velocity.VelocityContext;

public class HtmlAcceptanceTestReporter
extends HtmlReporter
implements AcceptanceTestReporter {
    private static final String DEFAULT_ACCEPTANCE_TEST_REPORT = "velocity/default.vm";

    public HtmlAcceptanceTestReporter() {
        this.setTemplatePath(DEFAULT_ACCEPTANCE_TEST_REPORT);
    }

    public File generateReportFor(AcceptanceTestRun testRun) throws IOException {
        Preconditions.checkNotNull((Object)this.getOutputDirectory());
        VelocityContext context = new VelocityContext();
        context.put("testrun", (Object)testRun);
        String htmlContents = this.mergeVelocityTemplate(context);
        this.copyResourcesToOutputDirectory();
        String reportFilename = testRun.getReportName(ReportNamer.ReportType.HTML);
        return this.writeReportToOutputDirectory(reportFilename, htmlContents);
    }
}

