/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.thucydides.core.screenshots.ScreenshotSequence;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Photographer {
    private static final int MESSAGE_DIGEST_MASK = 255;
    private final TakesScreenshot driver;
    private final File targetDirectory;
    private final ScreenshotSequence screenshotSequence;
    private final MessageDigest digest;
    private static final Logger LOGGER = LoggerFactory.getLogger(Photographer.class);
    private static final ScreenshotSequence DEFAULT_SCREENSHOT_SEQUENCE = new ScreenshotSequence();

    public Photographer(TakesScreenshot driver, File targetDirectory) {
        this.driver = driver;
        this.targetDirectory = targetDirectory;
        this.screenshotSequence = DEFAULT_SCREENSHOT_SEQUENCE;
        this.digest = this.getMd5Digest();
    }

    private MessageDigest getMd5Digest() {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Failed to create digest for screenshot name.", (Throwable)e);
        }
        return md;
    }

    protected long nextScreenshotNumber() {
        return this.screenshotSequence.next();
    }

    private String nextScreenshotName(String prefix) {
        long nextScreenshotNumber = this.nextScreenshotNumber();
        return "screenshot-" + this.getMD5DigestFrom(prefix) + nextScreenshotNumber + ".png";
    }

    private String getMD5DigestFrom(String value) {
        byte[] messageDigest = this.digest.digest(value.getBytes());
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < messageDigest.length; ++i) {
            hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
        }
        return hexString.toString();
    }

    public File takeScreenshot(String prefix) throws IOException {
        File screenshot = (File)this.driver.getScreenshotAs(OutputType.FILE);
        File savedScreenshot = new File(this.targetDirectory, this.nextScreenshotName(prefix));
        FileUtils.copyFile((File)screenshot, (File)savedScreenshot);
        return savedScreenshot;
    }
}

