/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import net.thucydides.core.annotations.Title;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestStepGroup;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.steps.TestDescription;
import net.thucydides.core.util.NameConverter;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOutcome {
    private String methodName;
    private Story userStory;
    private Class testCase;
    private long duration;
    private long startTime;
    private Set<String> testedRequirement = new HashSet<String>();
    private final List<TestStep> testSteps = new ArrayList<TestStep>();
    private final Stack<TestStepGroup> groupStack = new Stack();

    public TestOutcome() {
        this.startTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public TestOutcome(String methodName) {
        this();
        this.methodName = methodName;
    }

    protected TestOutcome(String scenarioName, Story story, Class<?> testCase) {
        this(scenarioName);
        this.testCase = testCase;
        this.recordRequirementsTestedBy(testCase, scenarioName);
        this.setUserStory(story);
    }

    protected TestOutcome(String scenarioName, Class<?> testCase) {
        this(scenarioName);
        this.testCase = testCase;
        this.recordRequirementsTestedBy(testCase, scenarioName);
        this.initializeStoryFrom(testCase);
    }

    private void initializeStoryFrom(Class<?> testCase) {
        Story story = Story.from(Story.testedInTestCase(testCase));
        this.setUserStory(story);
    }

    private void recordRequirementsTestedBy(Class<?> testCase, String scenarioName) {
        TestDescription testDescription = new TestDescription(testCase, scenarioName);
        if (testDescription.methodExists()) {
            this.testedRequirement.addAll(testDescription.getAnnotatedRequirements());
        }
    }

    public static TestOutcome forTest(String testName, Class<?> testCase) {
        return new TestOutcome(testName, testCase);
    }

    public static TestOutcome forTestInStory(String testName, Story story) {
        return new TestOutcome(testName, story, null);
    }

    public static TestOutcome forTestInStory(String testName, Story story, Class<?> testClass) {
        return new TestOutcome(testName, story, testClass);
    }

    public String getTitle() {
        String annotatedTitle = this.getAnnotatedTitleFor(this.methodName);
        if (annotatedTitle != null) {
            return annotatedTitle;
        }
        return NameConverter.humanize(NameConverter.withNoArguments(this.methodName));
    }

    private String getAnnotatedTitleFor(String methodName) {
        Method testMethod;
        Title titleAnnotation;
        String annotatedTitle = null;
        if (this.testCase != null && this.currentTestCaseHasMethodCalled(methodName) && (titleAnnotation = (testMethod = this.getMethodCalled(methodName)).getAnnotation(Title.class)) != null) {
            annotatedTitle = titleAnnotation.value();
        }
        return annotatedTitle;
    }

    private boolean currentTestCaseHasMethodCalled(String methodName) {
        return this.getMethodCalled(methodName) != null;
    }

    private Method getMethodCalled(String methodName) {
        String baseMethodName = NameConverter.withNoArguments(methodName);
        try {
            return this.testCase.getMethod(baseMethodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public String getStoryTitle() {
        return this.getTitleFrom(this.userStory);
    }

    private String getTitleFrom(Story userStory) {
        return userStory.getName();
    }

    public String getReportName(ReportNamer.ReportType type) {
        ReportNamer reportNamer = new ReportNamer(type);
        return reportNamer.getNormalizedTestNameFor(this);
    }

    public String getReportName(ReportNamer.ReportType type, String qualifier) {
        ReportNamer reportNamer = new ReportNamer(type);
        if (qualifier == null) {
            return reportNamer.getNormalizedTestNameFor(this);
        }
        return reportNamer.getNormalizedTestNameFor(this, qualifier);
    }

    public String getReportName() {
        return this.getReportName(ReportNamer.ReportType.ROOT);
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    private String normalizedFormOf(String name) {
        return name.replaceAll("\\s", "_").toLowerCase(Locale.getDefault());
    }

    public void testsRequirement(String requirement) {
        Preconditions.checkNotNull((Object)requirement);
        this.testedRequirement.add(requirement);
    }

    public Set<String> getTestedRequirements() {
        return ImmutableSet.copyOf(this.testedRequirement);
    }

    public List<TestStep> getTestSteps() {
        return ImmutableList.copyOf(this.testSteps);
    }

    public TestResult getResult() {
        TestResultList testResults = new TestResultList(this.getCurrentTestResults());
        return testResults.getOverallResult();
    }

    public void updateMostResultTestStepResult(TestResult result) {
        if (this.testSteps.size() > 0) {
            this.testSteps.get(this.testSteps.size() - 1).setResult(result);
        }
    }

    public void recordStep(TestStep step) {
        Preconditions.checkNotNull((Object)step.getDescription(), (Object)"The test step description was not defined.");
        if (this.groupStack.isEmpty()) {
            this.testSteps.add(step);
        } else {
            this.addStepToCurrentGroup(step);
        }
    }

    private void addStepToCurrentGroup(TestStep step) {
        TestStepGroup group = this.groupStack.peek();
        group.addTestStep(step);
    }

    public void setDefaultGroupResult(TestResult result) {
        if (!this.groupStack.isEmpty()) {
            TestStepGroup group = this.groupStack.peek();
            group.setDefaultResult(result);
        }
    }

    public TestStepGroup getCurrentGroup() {
        if (!this.groupStack.isEmpty()) {
            return this.groupStack.peek();
        }
        return null;
    }

    public ApplicationFeature getFeature() {
        if (this.getUserStory() != null) {
            return this.obtainFeatureFromUserStory();
        }
        return null;
    }

    private ApplicationFeature obtainFeatureFromUserStory() {
        return this.getUserStory().getFeature();
    }

    private List<TestResult> getCurrentTestResults() {
        return Lambda.convert(this.testSteps, (Converter)new ExtractTestResultsConverter());
    }

    public Integer getStepCount() {
        return this.testSteps.size();
    }

    public Integer getSuccessCount() {
        List<TestStep> allTestSteps = this.getNestedTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isSuccessful())).size();
    }

    private List<TestStep> getNestedTestSteps() {
        ArrayList<TestStep> allNestedTestSteps = new ArrayList<TestStep>();
        for (TestStep testStep : this.testSteps) {
            allNestedTestSteps.addAll(testStep.getFlattenedSteps());
        }
        return allNestedTestSteps;
    }

    public Integer getFailureCount() {
        List<TestStep> allTestSteps = this.getNestedTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isFailure())).size();
    }

    public Integer getIgnoredCount() {
        List<TestStep> allTestSteps = this.getNestedTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isIgnored())).size();
    }

    public Integer getSkippedCount() {
        List<TestStep> allTestSteps = this.getNestedTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isSkipped())).size();
    }

    public Integer getPendingCount() {
        List<TestStep> allTestSteps = this.getNestedTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isPending())).size();
    }

    public Boolean isSuccess() {
        return this.getResult() == TestResult.SUCCESS;
    }

    public Boolean isFailure() {
        return this.getResult() == TestResult.FAILURE;
    }

    public Boolean isPending() {
        return this.getResult() == TestResult.PENDING;
    }

    public Set<String> getAllTestedRequirements() {
        HashSet<String> allTestedRequirements = new HashSet<String>();
        allTestedRequirements.addAll(this.getTestedRequirements());
        for (TestStep step : this.getTestSteps()) {
            allTestedRequirements.addAll(step.getTestedRequirements());
        }
        return allTestedRequirements;
    }

    public void setUserStory(Story userStory) {
        Preconditions.checkState((this.userStory == null ? 1 : 0) != 0);
        this.userStory = userStory;
    }

    public Story getUserStory() {
        return this.userStory;
    }

    public void recordDuration() {
        this.setDuration(System.currentTimeMillis() - this.startTime);
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        if (this.duration == 0L && this.testSteps != null && this.testSteps.size() > 0) {
            return (Long)Lambda.sum(this.testSteps, (Object)((TestStep)Lambda.on(TestStep.class)).getDuration());
        }
        return this.duration;
    }

    public void startGroup(String description) {
        TestStepGroup newGroup = new TestStepGroup(description);
        if (this.currentlyInGroup()) {
            this.addStepToCurrentGroup(newGroup);
        } else {
            this.testSteps.add(newGroup);
        }
        this.groupStack.push(newGroup);
    }

    private boolean currentlyInGroup() {
        return !this.groupStack.isEmpty();
    }

    public void endGroup() {
        if (!this.groupStack.isEmpty()) {
            TestStepGroup group = this.groupStack.pop();
            group.recordDuration();
        }
    }

    public Integer countTestSteps() {
        return this.getNestedTestSteps().size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractTestResultsConverter
    implements Converter<TestStep, TestResult> {
        private ExtractTestResultsConverter() {
        }

        public TestResult convert(TestStep step) {
            return step.getResult();
        }
    }
}

