/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages.components;

import java.util.Set;
import net.thucydides.core.webelements.MultipleSelect;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dropdown {
    private final WebElement dropdown;
    private final Select selectField;

    private Dropdown(WebElement dropdown) {
        this.dropdown = dropdown;
        this.selectField = new Select(dropdown);
    }

    public static Dropdown forWebElement(WebElement webElement) {
        return new Dropdown(webElement);
    }

    public void select(String visibleLabel) {
        this.selectField.selectByVisibleText(visibleLabel);
    }

    public void selectMultipleItems(String ... selectedLabels) {
        for (String selectedLabel : selectedLabels) {
            String optionPath = String.format("//option[.='%s']", selectedLabel);
            WebElement option = this.dropdown.findElement(By.xpath((String)optionPath));
            option.click();
        }
    }

    public Set<String> getSelectedOptionLabels() {
        MultipleSelect multipleSelect = new MultipleSelect(this.dropdown);
        return multipleSelect.getSelectedOptionLabels();
    }

    public Set<String> getSelectedOptionValues() {
        MultipleSelect multipleSelect = new MultipleSelect(this.dropdown);
        return multipleSelect.getSelectedOptionValues();
    }

    public String getSelectedValue() {
        return this.selectField.getFirstSelectedOption().getValue();
    }

    public String getSelectedLabel() {
        return this.selectField.getFirstSelectedOption().getText();
    }
}

