/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.thucydides.core.screenshots.ScreenshotException;
import net.thucydides.core.screenshots.ScreenshotSequence;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Photographer {
    private static final int MESSAGE_DIGEST_MASK = 255;
    private static final int PNG_SUFFIX_LENGTH = ".png".length();
    private final WebDriver driver;
    private final File targetDirectory;
    private final ScreenshotSequence screenshotSequence;
    private final MessageDigest digest;
    private static final Logger LOGGER = LoggerFactory.getLogger(Photographer.class);
    private static final ScreenshotSequence DEFAULT_SCREENSHOT_SEQUENCE = new ScreenshotSequence();

    public Photographer(WebDriver driver, File targetDirectory) {
        this.driver = driver;
        this.targetDirectory = targetDirectory;
        this.screenshotSequence = DEFAULT_SCREENSHOT_SEQUENCE;
        this.digest = this.getMd5Digest();
    }

    private MessageDigest getMd5Digest() {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Failed to create digest for screenshot name.", (Throwable)e);
        }
        return md;
    }

    protected long nextScreenshotNumber() {
        return this.screenshotSequence.next();
    }

    private String nextScreenshotName(String prefix) {
        long nextScreenshotNumber = this.nextScreenshotNumber();
        return "screenshot-" + this.getMD5DigestFrom(prefix) + nextScreenshotNumber + ".png";
    }

    private String getMD5DigestFrom(String value) {
        byte[] messageDigest = this.digest.digest(value.getBytes());
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < messageDigest.length; ++i) {
            hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
        }
        return hexString.toString();
    }

    public File takeScreenshot(String prefix) {
        File screenshot;
        if (this.driverCanTakeSnapehots() && (screenshot = (File)((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE)) != null) {
            try {
                return this.saveScreenshoot(prefix, screenshot);
            }
            catch (IOException e) {
                throw new ScreenshotException("Screenshot could not be saved", e);
            }
            catch (WebDriverException e) {
                throw new ScreenshotException("Screenshot could not be saved", e);
            }
        }
        return null;
    }

    protected File saveScreenshoot(String prefix, File screenshot) throws IOException {
        File savedScreenshot = new File(this.targetDirectory, this.nextScreenshotName(prefix));
        FileUtils.copyFile((File)screenshot, (File)savedScreenshot);
        this.savePageSourceFor(savedScreenshot.getAbsolutePath());
        return savedScreenshot;
    }

    private boolean driverCanTakeSnapehots() {
        try {
            TakesScreenshot screenshotTaker = (TakesScreenshot)this.driver;
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private void savePageSourceFor(String screenshotFile) throws IOException {
        if (WebDriver.class.isAssignableFrom(this.driver.getClass())) {
            WebDriver webdriver = this.driver;
            String pageSource = webdriver.getPageSource();
            File savedSource = new File(this.sourceCodeFileFor(screenshotFile));
            FileUtils.writeStringToFile((File)savedSource, (String)pageSource);
        }
    }

    private String sourceCodeFileFor(String screenshotFile) {
        String rootFilename = screenshotFile.substring(0, screenshotFile.length() - PNG_SUFFIX_LENGTH);
        return rootFilename + ".html";
    }

    public File getMatchingSourceCodeFor(File screenshot) {
        return new File(this.sourceCodeFileFor(screenshot.getAbsolutePath()));
    }
}

