/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.ScenarioSteps;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepInterceptor;
import net.thucydides.core.steps.StepListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepFactory {
    private final Pages pages;
    private final List<StepListener> listeners = new ArrayList<StepListener>();
    private final List<ScenarioSteps> managedSteps = new ArrayList<ScenarioSteps>();
    private static final Class<?>[] CONSTRUCTOR_ARG_TYPES = new Class[]{Pages.class};

    public StepFactory(Pages pages) {
        this.pages = pages;
    }

    public void addListener(StepListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public <T extends ScenarioSteps> T newSteps(Class<T> scenarioStepsClass) {
        Enhancer e = new Enhancer();
        e.setSuperclass(scenarioStepsClass);
        StepInterceptor stepInterceptor = new StepInterceptor(scenarioStepsClass, this.listeners);
        e.setCallback((Callback)stepInterceptor);
        Object[] arguments = new Object[]{this.pages};
        ScenarioSteps steps = (ScenarioSteps)e.create((Class[])CONSTRUCTOR_ARG_TYPES, arguments);
        this.instanciateAnyNestedStepLibrariesIn(steps, scenarioStepsClass);
        this.managedSteps.add(steps);
        return (T)steps;
    }

    private void instanciateAnyNestedStepLibrariesIn(ScenarioSteps steps, Class<? extends ScenarioSteps> scenarioStepsClass) {
        StepAnnotations.injectNestedScenarioStepsInto(steps, this, scenarioStepsClass);
    }

    public void notifyStepFinished() {
        for (ScenarioSteps step : this.managedSteps) {
            step.done();
        }
    }
}

