/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import net.thucydides.core.pages.PageConfiguration;
import net.thucydides.core.pages.PageObject;
import net.thucydides.core.pages.PageUrls;
import net.thucydides.core.pages.PagesEventListener;
import net.thucydides.core.pages.WrongPageError;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pages
implements Serializable {
    private transient WebDriver driver;
    private static final Logger LOGGER = LoggerFactory.getLogger(Pages.class);
    private String defaultBaseUrl;
    private final transient PageConfiguration pageConfiguration = new PageConfiguration();
    private WebdriverProxyFactory proxyFactory = WebdriverProxyFactory.getFactory();

    public Pages() {
    }

    public Pages(WebDriver driver) {
        this();
        this.driver = driver;
    }

    public PageConfiguration getPageConfiguration() {
        return this.pageConfiguration;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    protected WebdriverProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public void start() {
        this.getDriver().get(this.getStartingUrl());
    }

    public <T extends PageObject> T getAt(Class<T> pageObjectClass) {
        return this.currentPageAt(pageObjectClass);
    }

    public <T extends PageObject> T get(Class<T> pageObjectClass) {
        return this.currentPageAt(pageObjectClass);
    }

    public <T extends PageObject> T currentPageAt(Class<T> pageObjectClass) {
        String currentUrl;
        PageObject pageCandidate = this.getCurrentPageOfType(pageObjectClass);
        if (!pageCandidate.matchesAnyUrl() && !pageCandidate.compatibleWithUrl(currentUrl = this.getDriver().getCurrentUrl())) {
            this.thisIsNotThePageYourLookingFor(pageObjectClass);
        }
        pageCandidate.setDefaultBaseUrl(this.getDefaultBaseUrl());
        return (T)pageCandidate;
    }

    public boolean isCurrentPageAt(Class<? extends PageObject> pageObjectClass) {
        try {
            PageObject pageCandidate = this.getCurrentPageOfType(pageObjectClass);
            String currentUrl = this.getDriver().getCurrentUrl();
            return pageCandidate.compatibleWithUrl(currentUrl);
        }
        catch (WrongPageError e) {
            return false;
        }
    }

    private PageObject getCurrentPageOfType(Class<? extends PageObject> pageObjectClass) {
        PageObject currentPage = null;
        try {
            Class[] constructorArgs = new Class[]{WebDriver.class};
            Constructor<? extends PageObject> constructor = pageObjectClass.getConstructor(constructorArgs);
            currentPage = constructor.newInstance(this.driver);
        }
        catch (NoSuchMethodException e) {
            LOGGER.info("This page object does not appear have a constructor that takes a WebDriver parameter: " + pageObjectClass, (Throwable)e);
            this.thisIsNotThePageYourLookingFor(pageObjectClass);
        }
        catch (Exception e) {
            LOGGER.info("Failed to instantiate page of type " + pageObjectClass, (Throwable)e);
            this.thisIsNotThePageYourLookingFor(pageObjectClass);
        }
        return currentPage;
    }

    private void thisIsNotThePageYourLookingFor(Class<? extends PageObject> pageObjectClass) {
        String errorDetails = "This is not the page you're looking for:\nI was looking for a page compatible with " + pageObjectClass + "\n" + "I was at the URL " + this.getDriver().getCurrentUrl();
        throw new WrongPageError(errorDetails);
    }

    public String getDefaultBaseUrl() {
        String baseUrl = this.defaultBaseUrl;
        if (StringUtils.isNotEmpty((String)PageConfiguration.getCurrentConfiguration().getBaseUrl())) {
            baseUrl = PageConfiguration.getCurrentConfiguration().getBaseUrl();
        }
        if (StringUtils.isNotEmpty((String)this.pageConfiguration.getBaseUrl())) {
            baseUrl = this.pageConfiguration.getBaseUrl();
        }
        return baseUrl;
    }

    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.defaultBaseUrl = defaultBaseUrl;
    }

    public String getStartingUrl() {
        return PageUrls.getUrlFrom(this.getDefaultBaseUrl());
    }

    public void notifyWhenDriverOpens() {
        PagesEventListener eventListener = new PagesEventListener(this);
        if (this.getDriver() != null && !this.usingProxiedWebDriver()) {
            this.start();
        }
        this.getProxyFactory().registerListener(eventListener);
    }

    private boolean usingProxiedWebDriver() {
        return this.getDriver() instanceof WebDriverFacade;
    }
}

