/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import net.thucydides.core.webdriver.WebDriverFacade;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverBackedSelenium;
import org.openqa.selenium.WebElement;

public class WebElementFacade {
    private final WebElement webElement;
    private final WebDriver driver;

    public WebElementFacade(WebDriver driver, WebElement webElement) {
        this.driver = driver;
        this.webElement = webElement;
    }

    public boolean isVisible() {
        try {
            return this.webElement.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean isCurrentlyVisible() {
        try {
            return this.webElement.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public void shouldBeVisible() {
        if (!this.isVisible()) {
            throw new AssertionError((Object)"Element should be visible");
        }
    }

    public void shouldBeCurrentlyVisible() {
        if (!this.isCurrentlyVisible()) {
            throw new AssertionError((Object)"Element should be visible");
        }
    }

    public void shouldNotBeVisible() {
        if (this.isVisible()) {
            throw new AssertionError((Object)"Element should not be visible");
        }
    }

    public void shouldNotBeCurrentlyVisible() {
        if (this.isCurrentlyVisible()) {
            throw new AssertionError((Object)"Element should not be visible");
        }
    }

    public boolean hasFocus() {
        WebDriverFacade driverFacade = (WebDriverFacade)this.driver;
        WebDriver proxiedDriver = driverFacade.getProxiedDriver();
        WebDriverBackedSelenium selenium = new WebDriverBackedSelenium(proxiedDriver, proxiedDriver.getCurrentUrl());
        String activeElement = selenium.getEval("window.document.activeElement");
        return this.webElement.toString().equals(activeElement);
    }

    public boolean containsText(String value) {
        return this.webElement.getText().contains(value);
    }

    public void shouldContainText(String textValue) {
        if (!this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the web element", textValue);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void shouldNotContainText(String textValue) {
        if (this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the web element", textValue);
            throw new AssertionError((Object)errorMessage);
        }
    }
}

