/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages.components;

import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.WebElement;

public class FileToUpload {
    private final String filename;
    private final Pattern windowsPath = Pattern.compile("/[A-Z]:.*");
    static final String WINDOWS_PATH_PATTERN = "^/?[A-Z]:.*";
    Pattern pattern = Pattern.compile("^/?[A-Z]:.*");

    public FileToUpload(String filename) {
        this.filename = this.isOnTheClasspath(filename) ? this.getFileFromResourcePath(filename) : this.getFileFromFileSystem(filename);
    }

    private boolean isOnTheClasspath(String filename) {
        if (filename.startsWith("/") && !this.isAFullWindowsPath(filename)) {
            return this.resourceOnClasspath(filename) != null;
        }
        return false;
    }

    private URL resourceOnClasspath(String filename) {
        ClassLoader cldr = Thread.currentThread().getContextClassLoader();
        return cldr.getResource(filename);
    }

    private boolean isAFullWindowsPath(String filename) {
        boolean res = this.pattern.matcher(filename).matches();
        return this.pattern.matcher(filename).find();
    }

    private String getFileFromResourcePath(String filename) {
        return this.resourceOnClasspath(filename).getFile();
    }

    private String getFileFromFileSystem(String filename) {
        File fileToUpload = new File(filename);
        return fileToUpload.getAbsolutePath();
    }

    public void to(WebElement uploadFileField) {
        uploadFileField.sendKeys(new CharSequence[]{this.osSpecificPathOf(this.filename)});
    }

    private String osSpecificPathOf(String fileToUpload) {
        if (this.isAWindows(fileToUpload)) {
            return this.windowsNative(fileToUpload);
        }
        return fileToUpload;
    }

    private String windowsNative(String fileToUpload) {
        String bareFilename = fileToUpload.substring(1);
        return StringUtils.replace((String)bareFilename, (String)"/", (String)"\\");
    }

    private boolean isAWindows(String fileToUpload) {
        Matcher matcher = this.windowsPath.matcher(fileToUpload);
        return matcher.matches();
    }
}

