/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.reports.html.HtmlResourceCopier;
import net.thucydides.core.reports.html.TemplateManager;
import org.apache.commons.io.FileUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HtmlReporter {
    private static final String DEFAULT_RESOURCE_DIRECTORY = "report-resources";
    private String resourceDirectory = "report-resources";
    private File outputDirectory;
    private final TemplateManager templateManager = new TemplateManager();
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlReporter.class);
    private String templatePath;

    public Template getTemplate() {
        return this.templateManager.getTemplateFrom(this.getTemplatePath());
    }

    protected TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setResourceDirectory(String resourceDirectory) {
        this.resourceDirectory = resourceDirectory;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    protected void copyResourcesToOutputDirectory() throws IOException {
        this.updateResourceDirectoryFromSystemPropertyIfDefined();
        HtmlResourceCopier copier = new HtmlResourceCopier(this.getResourceDirectory());
        copier.copyHTMLResourcesTo(this.getOutputDirectory());
    }

    private void updateResourceDirectoryFromSystemPropertyIfDefined() {
        String systemDefinedResourceDirectory = System.getProperty(ThucydidesSystemProperty.REPORT_RESOURCE_PATH.getPropertyName());
        if (systemDefinedResourceDirectory != null) {
            this.setResourceDirectory(systemDefinedResourceDirectory);
        }
    }

    protected String mergeVelocityTemplate(Template template, VelocityContext context) {
        String htmlContents = "";
        StringWriter sw = new StringWriter();
        template.merge((Context)context, (Writer)sw);
        htmlContents = sw.toString();
        return htmlContents;
    }

    protected String mergeVelocityTemplate(VelocityContext context) {
        return this.mergeVelocityTemplate(this.getTemplate(), context);
    }

    protected File writeReportToOutputDirectory(String reportFilename, String htmlContents) throws IOException {
        File report = new File(this.getOutputDirectory(), reportFilename);
        FileUtils.writeStringToFile((File)report, (String)htmlContents);
        LOGGER.debug("Writing HTML report to " + report.getAbsolutePath());
        return report;
    }
}

