/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thucydides.core.annotations.Step;
import net.thucydides.core.annotations.StepGroup;
import net.thucydides.core.annotations.TestsRequirement;
import net.thucydides.core.annotations.TestsRequirements;
import net.thucydides.core.annotations.Title;
import net.thucydides.core.annotations.UserStoryCode;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.TestStatus;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedStepDescription {
    private final ExecutedStepDescription description;
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotatedStepDescription.class);

    public static AnnotatedStepDescription from(ExecutedStepDescription description) {
        return new AnnotatedStepDescription(description);
    }

    private AnnotatedStepDescription(ExecutedStepDescription description) {
        this.description = description;
    }

    public List<String> getAnnotatedRequirements() {
        ArrayList<String> requirements = new ArrayList<String>();
        Method testMethod = this.getTestMethod();
        if (testMethod != null) {
            this.addRequirementFrom(requirements, testMethod);
            this.addMultipleRequirementsFrom(requirements, testMethod);
        }
        return requirements;
    }

    private void addMultipleRequirementsFrom(List<String> requirements, Method testMethod) {
        TestsRequirements testRequirements = testMethod.getAnnotation(TestsRequirements.class);
        if (testRequirements != null) {
            requirements.addAll(Arrays.asList(testRequirements.value()));
        }
    }

    private void addRequirementFrom(List<String> requirements, Method testMethod) {
        TestsRequirement testsRequirement = testMethod.getAnnotation(TestsRequirement.class);
        if (testsRequirement != null) {
            requirements.add(testsRequirement.value());
        }
    }

    public Method getTestMethod() {
        if (this.getTestClass() != null) {
            return this.methodCalled(this.withNoArguments(this.description.getName()), this.getTestClass());
        }
        return null;
    }

    public Method getTestMethodIfPresent() {
        return this.findMethodCalled(this.withNoArguments(this.description.getName()), this.getTestClass());
    }

    private String withNoArguments(String methodName) {
        int firstSpace = methodName.indexOf(58);
        if (firstSpace > 0) {
            return methodName.substring(0, firstSpace);
        }
        return methodName;
    }

    private Class<?> getTestClass() {
        return this.description.getStepClass();
    }

    private Method methodCalled(String methodName, Class<?> testClass) {
        Method methodFound = this.findMethodCalled(methodName, testClass);
        if (methodFound == null) {
            throw new IllegalArgumentException("No test method called " + methodName + " was found in " + testClass);
        }
        return methodFound;
    }

    private Method findMethodCalled(String methodName, Class<?> testClass) {
        Method methodFound = null;
        if (testClass != null) {
            Method[] methods;
            for (Method method : methods = testClass.getMethods()) {
                if (!method.getName().equals(methodName)) continue;
                methodFound = method;
            }
        }
        return methodFound;
    }

    public String getAnnotatedTitle() {
        Method testMethod = this.getTestMethod();
        Title title = testMethod.getAnnotation(Title.class);
        if (title != null) {
            return title.value();
        }
        return null;
    }

    public String getOptionalAnnotatedTitle() {
        if (this.getTestClass() != null) {
            return this.getAnnotatedTitle();
        }
        return null;
    }

    private String getAnnotatedStepName() {
        return this.getNameFromStepAnnotationIn(this.getTestMethod());
    }

    private String getNameFromStepAnnotationIn(Method testMethod) {
        Step step = testMethod.getAnnotation(Step.class);
        if (step != null && !StringUtils.isEmpty((String)step.value())) {
            return step.value();
        }
        return null;
    }

    public String getName() {
        if (this.noClassIsDefined()) {
            return this.description.getName();
        }
        if (this.isAGroup()) {
            return this.groupName();
        }
        return this.stepName();
    }

    private boolean noClassIsDefined() {
        return this.description.getStepClass() == null;
    }

    private String groupName() {
        String annotatedGroupName = this.getGroupName();
        if (!StringUtils.isEmpty((String)annotatedGroupName)) {
            return annotatedGroupName;
        }
        return this.stepName();
    }

    private String stepName() {
        String annotationTitle = this.getAnnotatedTitle();
        if (!StringUtils.isEmpty((String)annotationTitle)) {
            return annotationTitle;
        }
        String annotatedStepName = this.getAnnotatedStepName();
        if (!StringUtils.isEmpty((String)annotatedStepName)) {
            return annotatedStepName;
        }
        return NameConverter.humanize(this.description.getName());
    }

    public boolean isAGroup() {
        Method testMethod = this.getTestMethodIfPresent();
        if (testMethod != null) {
            StepGroup testGroup = testMethod.getAnnotation(StepGroup.class);
            return testGroup != null;
        }
        return false;
    }

    private String getGroupName() {
        Method testMethod = this.getTestMethodIfPresent();
        StepGroup testGroup = testMethod.getAnnotation(StepGroup.class);
        return testGroup.value();
    }

    public boolean isPending() {
        Method testMethod = this.getTestMethodIfPresent();
        return testMethod != null && TestStatus.of(testMethod).isPending();
    }

    public boolean isIgnored() {
        Method testMethod = this.getTestMethodIfPresent();
        return testMethod != null && TestStatus.of(testMethod).isIgnored();
    }

    public String getUserStoryCode() {
        UserStoryCode userStoryAnnotation;
        if (this.description.getStepClass() != null && (userStoryAnnotation = this.description.getStepClass().getAnnotation(UserStoryCode.class)) != null) {
            return userStoryAnnotation.value();
        }
        return "";
    }
}

