/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.steps.StepFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestStepResult {
    private List<StepFailure> failures = new ArrayList<StepFailure>();
    private int ignored = 0;
    private int run = 0;

    public void logFailure(StepFailure failure) {
        this.failures.add(failure);
    }

    public void logIgnoredTest() {
        ++this.ignored;
    }

    public void logExecutedTest() {
        ++this.run;
    }

    public int getFailureCount() {
        return this.failures.size();
    }

    public List<StepFailure> getFailures() {
        return ImmutableList.copyOf(this.failures);
    }

    public int getIgnoreCount() {
        return this.ignored;
    }

    public int getRunCount() {
        return this.run;
    }

    public boolean wasSuccessful() {
        return this.getFailureCount() == 0;
    }
}

