/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import net.thucydides.core.pages.WebElementFacade;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.AjaxElementLocator;
import org.openqa.selenium.support.pagefactory.AjaxElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.Annotations;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverFactory {
    public WebDriver newInstanceOf(SupportedWebDriver driverType) {
        if (driverType == null) {
            throw new IllegalArgumentException("Driver type cannot be null");
        }
        return this.newWebdriverInstance(driverType.getWebdriverClass());
    }

    public static Class<? extends WebDriver> getClassFor(SupportedWebDriver driverType) {
        return driverType.getWebdriverClass();
    }

    protected WebDriver newWebdriverInstance(Class<? extends WebDriver> webdriverClass) {
        try {
            return webdriverClass.newInstance();
        }
        catch (Exception cause) {
            throw new UnsupportedDriverException("Could not instantiate " + webdriverClass, cause);
        }
    }

    public static void initElementsWithAjaxSupport(Object pageObject, WebDriver driver) {
        DisplayedElementLocatorFactory finder = new DisplayedElementLocatorFactory(driver, Configuration.getElementTimeout());
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)pageObject);
    }

    public void restartBrowser() {
    }

    static class DisplayedElementLocatorFactory
    extends AjaxElementLocatorFactory {
        private final WebDriver driver;
        private final int timeOutInSeconds;

        public DisplayedElementLocatorFactory(WebDriver driver, int timeOutInSeconds) {
            super(driver, timeOutInSeconds);
            this.driver = driver;
            this.timeOutInSeconds = timeOutInSeconds;
        }

        public ElementLocator createLocator(Field field) {
            return new DisplayedElementLocator(this.driver, field, this.timeOutInSeconds);
        }
    }

    static class DisplayedElementLocator
    extends AjaxElementLocator {
        private static final List<String> QUICK_METHODS = Arrays.asList("isCurrentlyVisible");
        private static final List<String> QUICK_CLASSES = Arrays.asList(WebElementFacade.class.getName());
        private final Field field;
        private final WebDriver driver;

        DisplayedElementLocator(WebDriver driver, Field field, int timeOutInSeconds) {
            super(driver, field, timeOutInSeconds);
            this.field = field;
            this.driver = driver;
        }

        public WebElement findElement() {
            if (this.shouldFindElementImmediately()) {
                return this.findElementImmediately();
            }
            return super.findElement();
        }

        private boolean shouldFindElementImmediately() {
            for (StackTraceElement elt : Thread.currentThread().getStackTrace()) {
                if (!QUICK_METHODS.contains(elt.getMethodName()) || !QUICK_CLASSES.contains(elt.getClassName())) continue;
                return true;
            }
            return false;
        }

        public WebElement findElementImmediately() {
            Annotations annotations = new Annotations(this.field);
            By by = annotations.buildBy();
            return this.driver.findElement(by);
        }

        protected boolean isElementUsable(WebElement element) {
            return element.isDisplayed();
        }
    }
}

