/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebdriverManager {
    private final WebDriverFactory webDriverFactory;
    private final WebDriver webdriver;

    public WebdriverManager(WebDriverFactory webDriverFactory) {
        this.webDriverFactory = webDriverFactory;
        this.webdriver = this.newDriver();
    }

    protected WebDriver newDriver() {
        SupportedWebDriver supportedDriverType = Configuration.getDriverType();
        Class<? extends WebDriver> webDriverType = WebDriverFactory.getClassFor(supportedDriverType);
        return WebdriverProxyFactory.getFactory().proxyFor(webDriverType);
    }

    public void closeDriver() {
        if (this.getWebdriver() != null) {
            this.getWebdriver().close();
            this.getWebdriver().quit();
        }
    }

    public WebDriver getWebdriver() {
        return this.webdriver;
    }

    public Class<? extends WebDriver> getWebDriverClass() {
        return WebDriverFactory.getClassFor(Configuration.getDriverType());
    }
}

