/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.html.HtmlReporter;
import org.apache.velocity.VelocityContext;

public class HtmlAcceptanceTestReporter
extends HtmlReporter
implements AcceptanceTestReporter {
    private static final String DEFAULT_ACCEPTANCE_TEST_REPORT = "velocity/default.vm";
    private String qualifier;

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public HtmlAcceptanceTestReporter() {
        this.setTemplatePath(DEFAULT_ACCEPTANCE_TEST_REPORT);
    }

    public String getName() {
        return "html";
    }

    public File generateReportFor(TestOutcome testOutcome) throws IOException {
        Preconditions.checkNotNull((Object)this.getOutputDirectory());
        VelocityContext context = new VelocityContext();
        context.put("testrun", (Object)testOutcome);
        String htmlContents = this.mergeVelocityTemplate(context);
        this.copyResourcesToOutputDirectory();
        String reportFilename = this.reportFor(testOutcome);
        return this.writeReportToOutputDirectory(reportFilename, htmlContents);
    }

    private String reportFor(TestOutcome testOutcome) {
        if (this.qualifier != null) {
            return testOutcome.getReportName(ReportNamer.ReportType.HTML, this.qualifier);
        }
        return testOutcome.getReportName(ReportNamer.ReportType.HTML);
    }
}

