/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.Step;
import net.thucydides.core.annotations.StepGroup;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.ScenarioSteps;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.TestStepResult;
import net.thucydides.core.webdriver.WebdriverAssertionError;
import org.junit.Ignore;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepInterceptor
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<StepListener> listeners;
    private final Class<? extends ScenarioSteps> testStepClass;
    private TestStepResult resultTally;
    private List<Throwable> stepExceptions;
    private Throwable error = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(StepInterceptor.class);
    private final List<String> OBJECT_METHODS = Arrays.asList("toString", "equals", "hashcode", "clone", "notify", "notifyAll", "wait", "finalize");

    public StepInterceptor(Class<? extends ScenarioSteps> testStepClass, List<StepListener> listeners) {
        this.testStepClass = testStepClass;
        this.listeners = listeners;
        this.resultTally = new TestStepResult();
        this.stepExceptions = new ArrayList<Throwable>();
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (this.invokingLast(method)) {
            this.notifyFinished(method);
            return null;
        }
        Object result = null;
        if (this.baseClassMethod(method)) {
            return this.runNormalMethod(obj, method, args, proxy);
        }
        if (this.isATestGroup(method)) {
            this.notifyGroupStarted(method, args);
            result = this.runTestGroupStep(obj, method, args, proxy);
            this.notifyGroupFinished(method, args);
        } else {
            result = this.testStepResult(obj, method, args, proxy);
        }
        return result;
    }

    private boolean baseClassMethod(Method method) {
        return this.OBJECT_METHODS.contains(method.getName());
    }

    private Object testStepResult(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (!this.isATestStep(method) && !this.shouldSkip(method)) {
            return this.runNormalMethod(obj, method, args, proxy);
        }
        this.notifyStepStarted(method, args);
        if (this.shouldSkip(method)) {
            this.notifyTestSkippedFor(method, args);
            return null;
        }
        return this.runTestStep(obj, method, args, proxy);
    }

    private boolean shouldSkip(Method method) {
        return this.aPreviousStepHasFailed() || this.isPending(method) || this.isIgnored(method);
    }

    private boolean aPreviousStepHasFailed() {
        boolean aPreviousStepHasFailed = false;
        for (StepListener listener : this.listeners) {
            if (!listener.aStepHasFailed() || listener.isDataDriven()) continue;
            aPreviousStepHasFailed = true;
        }
        return aPreviousStepHasFailed;
    }

    private Object runNormalMethod(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        LOGGER.info("Running test step " + this.getTestNameFrom(method, args, false));
        Object result = null;
        try {
            result = this.invokeMethod(obj, method, args, proxy);
        }
        catch (AssertionError assertionError) {
            this.error = assertionError;
            this.stepExceptions.add((Throwable)((Object)assertionError));
            this.notifyFailureOf(method, args, (Throwable)((Object)assertionError));
        }
        catch (WebDriverException webdriverException) {
            this.error = webdriverException;
            this.stepExceptions.add(webdriverException);
            this.notifyFailureOf(method, args, webdriverException);
        }
        return result;
    }

    private Object runTestGroupStep(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result;
        block2: {
            LOGGER.info("Running test step group " + this.getTestNameFrom(method, args, false));
            result = null;
            try {
                result = proxy.invokeSuper(obj, args);
            }
            catch (AssertionError assertionError) {
                if (this.stepExceptions.contains(assertionError)) break block2;
                this.error = assertionError;
                this.stepExceptions.add((Throwable)((Object)assertionError));
                this.notifyFailureOf(method, args, (Throwable)((Object)assertionError));
            }
        }
        return result;
    }

    private boolean isATestGroup(Method method) {
        return this.getTestGroupAnnotationFor(method) != null;
    }

    private StepGroup getTestGroupAnnotationFor(Method method) {
        return method.getAnnotation(StepGroup.class);
    }

    private boolean isATestStep(Method method) {
        Step stepAnnotation = method.getAnnotation(Step.class);
        return stepAnnotation != null;
    }

    private boolean isIgnored(Method method) {
        Ignore ignoreAnnotation = method.getAnnotation(Ignore.class);
        return ignoreAnnotation != null;
    }

    private Object runTestStep(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        LOGGER.info("Running test step " + this.getTestNameFrom(method, args, false));
        Object result = null;
        try {
            result = proxy.invokeSuper(obj, args);
        }
        catch (AssertionError assertionError) {
            this.error = assertionError;
            this.stepExceptions.add((Throwable)((Object)assertionError));
            LOGGER.debug("Addertion error caught - notifying of failure " + assertionError);
            this.notifyFailureOf(method, args, (Throwable)((Object)assertionError));
        }
        catch (WebDriverException webdriverException) {
            this.error = webdriverException;
            WebdriverAssertionError webdriverAssertionError = new WebdriverAssertionError(this.error.getMessage(), this.error);
            this.stepExceptions.add((Throwable)((Object)webdriverAssertionError));
            this.notifyFailureOf(method, args, (Throwable)((Object)webdriverAssertionError));
        }
        this.notifyTestFinishedFor(method, args);
        this.resultTally.logExecutedTest();
        LOGGER.info("Test step done: " + this.getTestNameFrom(method, args, false));
        return result;
    }

    private Object invokeMethod(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        return proxy.invokeSuper(obj, args);
    }

    private boolean isPending(Method method) {
        Pending pendingAnnotation = method.getAnnotation(Pending.class);
        return pendingAnnotation != null;
    }

    private void notifyTestFinishedFor(Method method, Object[] args) {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args));
        for (StepListener listener : this.listeners) {
            listener.stepFinished(description);
        }
    }

    private String getTestNameFrom(Method method, Object[] args) {
        return this.getTestNameFrom(method, args, true);
    }

    private String getTestNameFrom(Method method, Object[] args, boolean addMarkup) {
        if (args == null || args.length == 0) {
            return method.getName();
        }
        return this.testNameWithArguments(method, args, addMarkup);
    }

    private String testNameWithArguments(Method method, Object[] args, boolean addMarkup) {
        StringBuffer testName = new StringBuffer(method.getName());
        testName.append(": ");
        if (addMarkup) {
            if (args.length == 1) {
                testName.append("<span class='single-parameter'>");
            } else {
                testName.append("<span class='parameters'>");
            }
        }
        boolean isFirst = true;
        for (Object arg : args) {
            if (!isFirst) {
                testName.append(", ");
            }
            testName.append(arg);
            isFirst = false;
        }
        if (addMarkup) {
            testName.append("</span>");
        }
        return testName.toString();
    }

    private void notifyTestSkippedFor(Method method, Object[] args) throws Exception {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args));
        for (StepListener listener : this.listeners) {
            listener.stepIgnored(description);
        }
        this.resultTally.logIgnoredTest();
    }

    private void notifyFailureOf(Method method, Object[] args, Throwable cause) throws Exception {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args));
        StepFailure failure = new StepFailure(description, cause);
        for (StepListener listener : this.listeners) {
            listener.stepFailed(failure);
        }
        this.resultTally.logFailure(failure);
    }

    private void notifyFinished(Method method) throws Exception {
        for (StepListener listener : this.listeners) {
            listener.testFinished(this.resultTally);
        }
    }

    private void notifyGroupStarted(Method method, Object[] args) throws Exception {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args));
        for (StepListener listener : this.listeners) {
            listener.stepGroupStarted(description);
        }
    }

    private void notifyGroupFinished(Method method, Object[] args) throws Exception {
        for (StepListener listener : this.listeners) {
            listener.stepGroupFinished();
        }
    }

    private void notifyStepStarted(Method method, Object[] args) {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args));
        for (StepListener listener : this.listeners) {
            listener.stepStarted(description);
        }
    }

    private boolean invokingLast(Method method) {
        return method.getName().equals("done") || method.getName().equals("finalize");
    }
}

