/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.thucydides.core.annotations.TestsRequirement;
import net.thucydides.core.annotations.TestsRequirements;
import net.thucydides.core.annotations.Title;
import net.thucydides.core.steps.TestMethodNotFoundException;
import net.thucydides.core.util.NameConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDescription {
    private final Class<?> testClass;
    private final String methodName;
    private static final Logger LOGGER = LoggerFactory.getLogger(TestDescription.class);

    public TestDescription(Class<?> testClass, String methodName) {
        this.testClass = testClass;
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getName() {
        String annotatedTitle = this.getAnnotatedTitle();
        if (annotatedTitle != null) {
            return annotatedTitle;
        }
        return NameConverter.humanize(this.getMethodName());
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Method getTestMethod() {
        Method testMethod = null;
        if (this.getTestClass() != null) {
            testMethod = this.methodCalled(NameConverter.withNoArguments(this.methodName), this.getTestClass());
        }
        if (testMethod == null) {
            LOGGER.error("No test method called {} was found in {}", (Object)this.methodName, this.testClass);
            throw new TestMethodNotFoundException("No test method called " + this.methodName + " was found in " + this.testClass);
        }
        return testMethod;
    }

    private Method methodCalled(String methodName, Class<?> testClass) {
        Method[] methods;
        Method testMethod = null;
        for (Method method : methods = testClass.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            testMethod = method;
            break;
        }
        return testMethod;
    }

    public String getAnnotatedTitle() {
        Method testMethod = this.getTestMethod();
        Title title = testMethod.getAnnotation(Title.class);
        if (title != null) {
            return title.value();
        }
        return null;
    }

    public Set<String> getAnnotatedRequirements() {
        HashSet<String> requirements = new HashSet<String>();
        if (this.getTestClass() != null) {
            Method testMethod = this.getTestMethod();
            this.addRequirementFrom(requirements, testMethod);
            this.addMultipleRequirementsFrom(requirements, testMethod);
        }
        return requirements;
    }

    private void addMultipleRequirementsFrom(Set<String> requirements, Method testMethod) {
        TestsRequirements testRequirements = testMethod.getAnnotation(TestsRequirements.class);
        if (testRequirements != null) {
            requirements.addAll(Arrays.asList(testRequirements.value()));
        }
    }

    private void addRequirementFrom(Set<String> requirements, Method testMethod) {
        TestsRequirement testsRequirement = testMethod.getAnnotation(TestsRequirement.class);
        if (testsRequirement != null) {
            requirements.add(testsRequirement.value());
        }
    }

    public boolean methodExists() {
        if (this.getTestClass() != null) {
            return this.methodCalled(NameConverter.withNoArguments(this.methodName), this.getTestClass()) != null;
        }
        return false;
    }
}

