/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.images;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ResizableImage {
    private final BufferedImage image;

    public ResizableImage(BufferedImage image) {
        this.image = image;
    }

    public static ResizableImage loadFrom(File screenshotFile) throws IOException {
        return new ResizableImage(ImageIO.read(screenshotFile));
    }

    public int getWitdh() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public ResizableImage rescaleCanvas(int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, 3);
        this.fillWithWhiteBackground(resizedImage);
        resizedImage.setData(this.image.getRaster());
        return new ResizableImage(resizedImage);
    }

    private void fillWithWhiteBackground(BufferedImage resizedImage) {
        Graphics2D g2d = resizedImage.createGraphics();
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fill(new Rectangle2D.Float(0.0f, 0.0f, resizedImage.getWidth(), resizedImage.getHeight()));
        g2d.dispose();
    }

    public void saveTo(File file) throws IOException {
        ImageIO.write((RenderedImage)this.image, "PNG", file);
    }
}

