/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang.StringUtils;

public class ReportNamer {
    private ReportType type;

    public ReportNamer(ReportType type) {
        this.type = type;
    }

    public String getNormalizedTestNameFor(TestOutcome testOutcome) {
        String testName = "";
        if (testOutcome.getUserStory() != null) {
            testName = NameConverter.underscore(testOutcome.getUserStory().getName());
        }
        String scenarioName = NameConverter.underscore(testOutcome.getMethodName());
        testName = NameConverter.withNoArguments(this.appendToIfNotNull(testName, scenarioName));
        return this.appendSuffixTo(testName);
    }

    private String appendToIfNotNull(String baseString, String nextElement) {
        String appendedString = baseString;
        appendedString = StringUtils.isNotEmpty((String)nextElement) ? (StringUtils.isNotEmpty((String)baseString) ? baseString + "_" + nextElement : nextElement) : baseString;
        return appendedString;
    }

    public String getNormalizedTestNameFor(TestOutcome testOutcome, String qualifier) {
        String userStory = "";
        if (testOutcome.getUserStory() != null) {
            userStory = NameConverter.underscore(testOutcome.getUserStory().getName()) + "_";
        }
        String normalizedQualifier = qualifier.replaceAll(" ", "_");
        return this.appendSuffixTo(userStory + NameConverter.withNoArguments(testOutcome.getMethodName()) + "_" + normalizedQualifier);
    }

    public String getNormalizedTestNameFor(Story userStory) {
        String testNameWithUnderscores = NameConverter.underscore(userStory.getName());
        return this.appendSuffixTo(testNameWithUnderscores);
    }

    public String getNormalizedTestNameFor(ApplicationFeature feature) {
        String testNameWithUnderscores = NameConverter.underscore(feature.getName());
        return this.appendSuffixTo(testNameWithUnderscores);
    }

    private String appendSuffixTo(String testNameWithUnderscores) {
        if (this.type == ReportType.ROOT) {
            return testNameWithUnderscores;
        }
        return testNameWithUnderscores + "." + this.type.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReportType {
        ROOT(""),
        XML("xml"),
        HTML("html");

        private String suffix;

        private ReportType(String suffix) {
            this.suffix = suffix;
        }

        public String toString() {
            return this.suffix;
        }
    }
}

