/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestStepGroup
extends TestStep {
    private List<TestStep> steps = new ArrayList<TestStep>();
    private TestResult defaultResult;

    @Override
    public void setResult(TestResult result) {
        this.setDefaultResult(result);
    }

    public void setDefaultResult(TestResult result) {
        this.defaultResult = result;
    }

    public TestStepGroup(String description) {
        super(description);
    }

    public void addTestStep(TestStep step) {
        this.steps.add(step);
    }

    @Override
    public String toString() {
        return "TestStepGroup{description=" + this.getDescription() + "steps=" + this.steps + '}';
    }

    @Override
    public TestResult getResult() {
        TestResultList resultList = new TestResultList(this.getChildResults());
        if (!resultList.isEmpty()) {
            return resultList.getOverallResult();
        }
        if (this.defaultResult != null) {
            return this.defaultResult;
        }
        return TestResult.PENDING;
    }

    private List<TestResult> getChildResults() {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        for (TestStep step : this.steps) {
            results.add(step.getResult());
        }
        return results;
    }

    public List<TestStep> getSteps() {
        return ImmutableList.copyOf(this.steps);
    }

    @Override
    public List<? extends TestStep> getFlattenedSteps() {
        ArrayList<? extends TestStep> nestedTestSteps = new ArrayList<TestStep>();
        for (TestStep step : this.steps) {
            nestedTestSteps.addAll(step.getFlattenedSteps());
        }
        return nestedTestSteps;
    }

    @Override
    public boolean isAGroup() {
        return true;
    }
}

