/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.ConcreteTestStep;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestStepGroup;
import net.thucydides.core.pages.InternalClock;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.screenshots.Photographer;
import net.thucydides.core.screenshots.ScreenshotException;
import net.thucydides.core.steps.AnnotatedStepDescription;
import net.thucydides.core.steps.DataDrivenStep;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.TestStepResult;
import net.thucydides.core.util.NameConverter;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseStepListener
implements StepListener {
    private final Collection<TestOutcome> testOutcomes;
    private TestOutcome currentTestOutcome;
    private Story testedStory;
    private Class<?> testClass;
    private ConcreteTestStep currentTestStep;
    private WebDriver driver;
    private File outputDirectory;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseStepListener.class);
    private boolean aStepHasFailed;
    private Throwable stepError;
    private InternalClock clock;
    private WebdriverProxyFactory proxyFactory = WebdriverProxyFactory.getFactory();

    private BaseStepListener(File outputDirectory) {
        this.testOutcomes = new ArrayList<TestOutcome>();
        this.clock = new InternalClock();
        this.outputDirectory = outputDirectory;
        this.aStepHasFailed = false;
        this.stepError = null;
    }

    protected WebdriverProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    protected InternalClock getClock() {
        return this.clock;
    }

    public BaseStepListener(Class<? extends WebDriver> driverClass, File outputDirectory) {
        this(outputDirectory);
        this.driver = this.getProxyFactory().proxyFor(driverClass);
    }

    public BaseStepListener(File outputDirectory, Pages pages) {
        this(outputDirectory);
        if (pages != null) {
            this.setDriverUsingPagesDriverIfDefined(pages);
        } else {
            this.createNewDriver();
        }
    }

    private void createNewDriver() {
        this.setDriver(this.getProxyFactory().proxyDriver());
    }

    private void setDriverUsingPagesDriverIfDefined(Pages pages) {
        if (pages.getDriver() != null) {
            this.setDriver(pages.getDriver());
        } else {
            this.createNewDriver();
            pages.setDriver(this.getDriver());
            pages.notifyWhenDriverOpens();
        }
    }

    @Override
    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    @Override
    public boolean aStepHasFailed() {
        return this.aStepHasFailed;
    }

    @Override
    public void noStepsHaveFailed() {
        this.aStepHasFailed = false;
        this.stepError = null;
    }

    @Override
    public boolean isDataDriven() {
        return DataDrivenStep.inProgress();
    }

    @Override
    public Throwable getStepError() {
        return this.stepError;
    }

    @Override
    public List<TestOutcome> getTestOutcomes() {
        return ImmutableList.copyOf(this.testOutcomes);
    }

    private void recordCurrentTestStep(ExecutedStepDescription description) {
        if (this.currentTestStep != null) {
            this.addAnyTestedRequirementsIn(description);
            String testName = AnnotatedStepDescription.from(description).getName();
            this.getCurrentStep().setDescription(testName);
            this.getCurrentStep().recordDuration();
            if (this.getCurrentTestOutcome() != null) {
                this.getCurrentTestOutcome().recordStep(this.currentTestStep);
                this.getCurrentTestOutcome().recordDuration();
            }
            this.finishTestStep();
        }
    }

    private void startNewTestStep(ExecutedStepDescription description) {
        this.currentTestStep = new ConcreteTestStep();
        this.currentTestStep.setDescription(description.getName());
    }

    private void finishTestStep() {
        this.currentTestStep = null;
    }

    private File grabScreenshotFileFor(String testName) {
        String snapshotName = NameConverter.underscore(testName);
        return this.getPhotographer().takeScreenshot(snapshotName);
    }

    public Photographer getPhotographer() {
        return new Photographer(this.driver, this.outputDirectory);
    }

    protected TestOutcome getCurrentTestOutcome() {
        return this.currentTestOutcome;
    }

    protected void startNewTestOutcomeFor(String testName, Story story) {
        LOGGER.debug("startNewTestOutcomeFor {}", (Object)testName);
        this.testedStory = story;
        this.currentTestOutcome = TestOutcome.forTestInStory(testName, this.testedStory, this.testClass);
        this.testOutcomes.add(this.currentTestOutcome);
        this.aStepHasFailed = false;
    }

    @Override
    public void testRunStartedFor(Class<?> testClass) {
        this.testClass = testClass;
        Story story = this.findStoryFrom(testClass);
        this.testRunStartedFor(story);
    }

    private Story findStoryFrom(Class<?> testClass) {
        Story story = null;
        story = this.storyIsDefinedIn(testClass) ? this.storyFrom(testClass) : Story.from(testClass);
        return story;
    }

    @Override
    public void testRunStartedFor(Story story) {
        this.testedStory = story;
    }

    private Story storyFrom(Class<?> testClass) {
        Class<?> testedStoryClass = Story.testedInTestCase(testClass);
        if (testedStoryClass != null) {
            return Story.from(testedStoryClass);
        }
        return null;
    }

    private boolean storyIsDefinedIn(Class<?> testClass) {
        return this.storyFrom(testClass) != null;
    }

    @Override
    public void testStarted(String testName) {
        LOGGER.debug("Starting test: {}", (Object)testName);
        this.startNewTestOutcomeFor(testName, this.testedStory);
        this.getCurrentTestOutcome().setMethodName(testName);
    }

    private void addAnyTestedRequirementsIn(ExecutedStepDescription description) {
        AnnotatedStepDescription testStepDescription = AnnotatedStepDescription.from(description);
        List<String> requirements = testStepDescription.getAnnotatedRequirements();
        for (String requirement : requirements) {
            this.currentTestStep.testsRequirement(requirement);
        }
    }

    public void testGroupStarted(ExecutedStepDescription description) {
        if (this.getCurrentTestOutcome() == null) {
            this.startNewTestOutcomeFor(description.getName(), this.testedStory);
            this.getCurrentTestOutcome().startGroup(description.getName());
        } else {
            this.getCurrentTestOutcome().startGroup(description.getName());
        }
        this.takeScreenshotForCurrentGroup();
    }

    private void takeScreenshotForCurrentGroup() {
        TestStepGroup currentGroup = this.getCurrentTestOutcome().getCurrentGroup();
        this.takeScreenshotForGroup(currentGroup);
    }

    private void takeScreenshotForGroup(TestStepGroup group) {
        File screenshot = this.grabScreenshotFileFor(group.getDescription());
        group.setScreenshot(screenshot);
        if (screenshot != null) {
            File sourcecode = this.getPhotographer().getMatchingSourceCodeFor(screenshot);
            group.setHtmlSource(sourcecode);
        }
    }

    private void markCurrentTestAs(TestResult result) {
        if (this.failureOccursBeforeAnyStepsHaveBeenExecuted(result)) {
            this.stepStarted(ExecutedStepDescription.withTitle("undefined"));
        }
        if (this.getCurrentStep() != null) {
            this.getCurrentStep().setResult(result);
        } else if (result == TestResult.FAILURE && this.getTestOutcomes().isEmpty()) {
            this.startNewTestStep(ExecutedStepDescription.withTitle("undefined"));
        }
    }

    private boolean failureOccursBeforeAnyStepsHaveBeenExecuted(TestResult result) {
        return result == TestResult.FAILURE && this.getCurrentStep() == null && this.getCurrentTestOutcome().getStepCount() == 0;
    }

    private TestStep getCurrentStep() {
        if (this.currentTestStep != null) {
            return this.currentTestStep;
        }
        return this.getCurrentTestOutcome().getCurrentGroup();
    }

    private void recordFailureDetailsInFailingTestStep(StepFailure failure) {
        if (this.currentTestStep != null) {
            this.getCurrentStep().failedWith(failure.getMessage(), failure.getException());
        }
    }

    private void pauseIfRequired() {
        int delay = Configuration.getStepDelay();
        if (delay > 0) {
            this.getClock().pauseFor(delay);
        }
    }

    private void takeScreenshotFor(ExecutedStepDescription description, TestResult result) {
        if (this.getCurrentStep() != null && this.shouldTakeScreenshotFor(result)) {
            try {
                String testName = this.aTestCalled(description);
                File screenshot = this.grabScreenshotFileFor(testName);
                this.getCurrentStep().setScreenshot(screenshot);
                if (screenshot != null) {
                    File sourcecode = this.getPhotographer().getMatchingSourceCodeFor(screenshot);
                    this.getCurrentStep().setHtmlSource(sourcecode);
                }
            }
            catch (ScreenshotException e) {
                LOGGER.warn("Failed to take screenshot", (Throwable)e);
            }
        }
    }

    private boolean shouldTakeScreenshotFor(TestResult result) {
        String onlySaveFailures = System.getProperty(ThucydidesSystemProperty.ONLY_SAVE_FAILING_SCREENSHOTS.getPropertyName(), "false");
        Boolean onlySaveFailureScreenshots = Boolean.valueOf(onlySaveFailures);
        return onlySaveFailureScreenshots == false || result == TestResult.FAILURE;
    }

    protected String aTestCalled(ExecutedStepDescription description) {
        return description.getName();
    }

    @Override
    public void stepStarted(ExecutedStepDescription description) {
        if (this.stepIsAGroup(description)) {
            this.testGroupStarted(description);
        } else {
            this.startNewTestStep(description);
        }
    }

    @Override
    public void stepFinished(ExecutedStepDescription description) {
        if (this.stepIsAGroup(description)) {
            this.takeScreenshotForCurrentGroup();
            this.getCurrentTestOutcome().endGroup();
        } else {
            this.markCurrentTestAs(TestResult.SUCCESS);
            this.takeScreenshotFor(description, TestResult.SUCCESS);
            this.recordCurrentTestStep(description);
        }
        this.pauseIfRequired();
    }

    @Override
    public void stepGroupStarted(String description) {
        this.stepGroupStarted(ExecutedStepDescription.withTitle(description));
    }

    @Override
    public void stepGroupStarted(ExecutedStepDescription description) {
        ExecutedStepDescription copiedDescription = description.clone();
        copiedDescription.setAGroup(true);
        this.testGroupStarted(copiedDescription);
    }

    @Override
    public void stepGroupFinished() {
        if (this.currentTestOutcome != null) {
            this.getCurrentTestOutcome().endGroup();
        }
    }

    @Override
    public void stepGroupFinished(TestResult result) {
        if (this.getCurrentTestOutcome() != null) {
            this.getCurrentTestOutcome().setDefaultGroupResult(result);
            this.getCurrentTestOutcome().endGroup();
        }
    }

    @Override
    public void stepSucceeded() {
        this.markCurrentTestAs(TestResult.SUCCESS);
    }

    @Override
    public void updateCurrentStepStatus(TestResult result) {
        if (this.currentTestStep == null) {
            this.updateMostRecentStepStatus(result);
        } else {
            this.markCurrentTestAs(result);
        }
    }

    private void updateMostRecentStepStatus(TestResult result) {
        this.getCurrentTestOutcome().updateMostResultTestStepResult(result);
    }

    @Override
    public void stepFailed(StepFailure failure) {
        this.stepFailedWith(failure);
        this.markCurrentTestAs(TestResult.FAILURE);
        this.recordFailureDetailsInFailingTestStep(failure);
        this.takeScreenshotFor(failure.getDescription(), TestResult.FAILURE);
        if (this.currentTestStep != null) {
            this.recordCurrentTestStep(failure.getDescription());
        }
    }

    private void stepFailedWith(StepFailure failure) {
        this.aStepHasFailed = true;
        this.stepError = failure.getException();
    }

    private boolean stepIsAGroup(ExecutedStepDescription description) {
        return description.isAGroup() || AnnotatedStepDescription.from(description).isAGroup();
    }

    @Override
    public void stepIgnored(ExecutedStepDescription description) {
        this.ensureThatTestHasStartedFor(description);
        if (AnnotatedStepDescription.from(description).isPending()) {
            this.markCurrentTestAs(TestResult.PENDING);
        } else if (AnnotatedStepDescription.from(description).isIgnored()) {
            this.ignoreStepMethodWith(description);
        } else {
            this.markCurrentTestAs(TestResult.SKIPPED);
        }
        if (this.currentTestStep != null) {
            this.recordCurrentTestStep(description);
        }
    }

    private void ensureThatTestHasStartedFor(ExecutedStepDescription description) {
        if (this.testRunNotStartedYet()) {
            this.testRunStartedFor(description.getStepClass());
        }
        if (this.testNotStartedYet()) {
            this.testStarted(description.getName());
        }
    }

    private boolean testRunNotStartedYet() {
        return this.testedStory == null;
    }

    private boolean testNotStartedYet() {
        return this.currentTestStep == null;
    }

    private void ignoreStepMethodWith(ExecutedStepDescription description) {
        if (this.currentTestStep == null) {
            this.startNewTestStep(description);
        }
        this.markCurrentTestAs(TestResult.IGNORED);
    }

    @Override
    public void testFinished(TestStepResult result) {
        LOGGER.debug("testFinished: ", (Object)result);
        this.currentTestOutcome = null;
    }
}

