/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.images.ResizableImage;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.Screenshot;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.html.HtmlReporter;
import org.apache.velocity.VelocityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlAcceptanceTestReporter
extends HtmlReporter
implements AcceptanceTestReporter {
    private static final String DEFAULT_ACCEPTANCE_TEST_REPORT = "velocity/default.vm";
    private static final String DEFAULT_ACCEPTANCE_TEST_SCREENSHOT = "velocity/screenshots.vm";
    private String qualifier;

    @Override
    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public String getName() {
        return "html";
    }

    @Override
    public File generateReportFor(TestOutcome testOutcome) throws IOException {
        Preconditions.checkNotNull((Object)this.getOutputDirectory());
        VelocityContext context = new VelocityContext();
        context.put("testrun", (Object)testOutcome);
        String htmlContents = this.mergeTemplate(DEFAULT_ACCEPTANCE_TEST_REPORT).usingContext(context);
        this.copyResourcesToOutputDirectory();
        this.generateScreenshotReportsFor(testOutcome);
        String reportFilename = this.reportFor(testOutcome);
        return this.writeReportToOutputDirectory(reportFilename, htmlContents);
    }

    private void generateScreenshotReportsFor(TestOutcome testOutcome) throws IOException {
        Preconditions.checkNotNull((Object)this.getOutputDirectory());
        List<Screenshot> screenshots = this.expandScreenshots(testOutcome.getScreenshots());
        String screenshotReport = this.withoutType(testOutcome.getReportName() + "_screenshots") + ".html";
        VelocityContext context = new VelocityContext();
        context.put("screenshots", screenshots);
        context.put("testOutcome", (Object)testOutcome);
        String htmlContents = this.mergeTemplate(DEFAULT_ACCEPTANCE_TEST_SCREENSHOT).usingContext(context);
        this.writeReportToOutputDirectory(screenshotReport, htmlContents);
    }

    private List<Screenshot> expandScreenshots(List<Screenshot> screenshots) throws IOException {
        ArrayList<Screenshot> expandScreenshotList = new ArrayList<Screenshot>();
        int maxWidth = this.maxScreenshotWidthIn(screenshots);
        int maxHeight = this.maxScreenshotHeightIn(screenshots);
        for (Screenshot screenshot : screenshots) {
            File screenshotFile = new File(this.getOutputDirectory(), screenshot.getFilename());
            if (screenshotFile.exists()) {
                ResizableImage scaledImage = ResizableImage.loadFrom(screenshotFile).rescaleCanvas(maxWidth, maxHeight);
                File scaledFile = new File(this.getOutputDirectory(), "scaled_" + screenshot.getFilename());
                scaledImage.saveTo(scaledFile);
                expandScreenshotList.add(new Screenshot(scaledFile.getName(), screenshot.getDescription()));
                continue;
            }
            expandScreenshotList.add(screenshot);
        }
        return expandScreenshotList;
    }

    private int maxScreenshotWidthIn(List<Screenshot> screenshots) throws IOException {
        int maxWidth = 0;
        for (Screenshot screenshot : screenshots) {
            File screenshotFile = new File(this.getOutputDirectory(), screenshot.getFilename());
            if (!screenshotFile.exists()) continue;
            maxWidth = this.maxWidthOf(maxWidth, screenshotFile);
        }
        return maxWidth;
    }

    private int maxWidthOf(int maxWidth, File screenshotFile) throws IOException {
        int width = ResizableImage.loadFrom(screenshotFile).getWitdh();
        if (width > maxWidth) {
            maxWidth = width;
        }
        return maxWidth;
    }

    private int maxScreenshotHeightIn(List<Screenshot> screenshots) throws IOException {
        int maxHeight = 0;
        for (Screenshot screenshot : screenshots) {
            File screenshotFile = new File(this.getOutputDirectory(), screenshot.getFilename());
            if (!screenshotFile.exists()) continue;
            maxHeight = this.maxHeightOf(maxHeight, screenshotFile);
        }
        return maxHeight;
    }

    private int maxHeightOf(int maxHeight, File screenshotFile) throws IOException {
        int height = ResizableImage.loadFrom(screenshotFile).getHeight();
        if (height > maxHeight) {
            maxHeight = height;
        }
        return maxHeight;
    }

    private String withoutType(String screenshot) {
        int dot = screenshot.lastIndexOf(46);
        if (dot > 0) {
            return screenshot.substring(0, dot);
        }
        return screenshot;
    }

    private String reportFor(TestOutcome testOutcome) {
        if (this.qualifier != null) {
            return testOutcome.getReportName(ReportNamer.ReportType.HTML, this.qualifier);
        }
        return testOutcome.getReportName(ReportNamer.ReportType.HTML);
    }
}

