/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thucydides.core.model.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestStep {
    private String description;
    private long duration;
    private long startTime;
    private Set<String> testedRequirement = new HashSet<String>();
    private String screenshotPath;
    private File screenshot;
    private File htmlSource;
    private String errorMessage;
    private Throwable cause;

    public TestStep() {
        this.startTime = System.currentTimeMillis();
    }

    public String toString() {
        return "TestStep{description='" + this.description + '\'' + '}';
    }

    public TestStep(String description) {
        this();
        this.description = description;
    }

    public void testsRequirement(String requirement) {
        this.testedRequirement.add(requirement);
    }

    public Set<String> getTestedRequirements() {
        return ImmutableSet.copyOf(this.testedRequirement);
    }

    public void recordDuration() {
        this.setDuration(System.currentTimeMillis() - this.startTime);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setScreenshot(File screenshot) {
        this.screenshot = screenshot;
    }

    public File getScreenshot() {
        return this.screenshot;
    }

    public void setScreenshotPath(String screenshotPath) {
        this.screenshotPath = screenshotPath;
    }

    public String getScreenshotPath() {
        return this.screenshotPath;
    }

    public String getScreenshotPage() {
        if (this.screenshot != null) {
            return "screenshot_" + this.withoutType(this.screenshot.getName()) + ".html";
        }
        return "";
    }

    private String withoutType(String screenshot) {
        int dot = screenshot.lastIndexOf(46);
        if (dot > 0) {
            return screenshot.substring(0, dot);
        }
        return screenshot;
    }

    public File getHtmlSource() {
        return this.htmlSource;
    }

    public void setHtmlSource(File htmlSource) {
        this.htmlSource = htmlSource;
    }

    public abstract void setResult(TestResult var1);

    public abstract TestResult getResult();

    public Boolean isSuccessful() {
        return this.getResult() == TestResult.SUCCESS;
    }

    public Boolean isFailure() {
        return this.getResult() == TestResult.FAILURE;
    }

    public Boolean isIgnored() {
        return this.getResult() == TestResult.IGNORED;
    }

    public Boolean isSkipped() {
        return this.getResult() == TestResult.SKIPPED;
    }

    public Boolean isPending() {
        return this.getResult() == TestResult.PENDING;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public void failedWith(String message, Throwable exception) {
        this.setResult(TestResult.FAILURE);
        this.errorMessage = message;
        this.cause = exception;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Throwable getException() {
        return this.cause;
    }

    public abstract List<? extends TestStep> getFlattenedSteps();

    public abstract boolean isAGroup();
}

