/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.features;

import com.google.common.base.Preconditions;
import net.thucydides.core.util.NameConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationFeature {
    private final Class<?> featureClass;
    private final String featureId;
    private final String featureName;

    public ApplicationFeature(String featureId, String featureName) {
        Preconditions.checkNotNull((Object)featureId);
        Preconditions.checkNotNull((Object)featureName);
        this.featureClass = null;
        this.featureId = featureId;
        this.featureName = featureName;
    }

    protected ApplicationFeature(Class<?> featureClass) {
        Preconditions.checkNotNull(featureClass);
        this.featureClass = featureClass;
        this.featureId = null;
        this.featureName = null;
    }

    public String getName() {
        if (this.featureName == null) {
            return this.getFeatureName();
        }
        return this.featureName;
    }

    public Class<?> getFeatureClass() {
        return this.featureClass;
    }

    public static ApplicationFeature from(Class<?> featureClass) {
        return new ApplicationFeature(featureClass);
    }

    protected String getFeatureName() {
        return NameConverter.humanize(this.simpleClassName());
    }

    public String getId() {
        if (this.featureId == null) {
            return this.canonicalClassName();
        }
        return this.featureId;
    }

    private String simpleClassName() {
        if (this.getFeatureClass() != null) {
            return this.getFeatureClass().getSimpleName();
        }
        return "";
    }

    private String canonicalClassName() {
        return this.getFeatureClass().getCanonicalName();
    }

    public boolean classesAreEqual(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationFeature)) {
            return false;
        }
        ApplicationFeature that = (ApplicationFeature)o;
        return !(this.featureClass != null ? !this.featureClass.equals(that.featureClass) : that.featureClass != null);
    }

    public boolean idAndNameAreEqual(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationFeature)) {
            return false;
        }
        ApplicationFeature that = (ApplicationFeature)o;
        if (this.featureId != null ? !this.featureId.equals(that.featureId) : that.featureId != null) {
            return false;
        }
        return !(this.featureName != null ? !this.featureName.equals(that.featureName) : that.featureName != null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationFeature)) {
            return false;
        }
        ApplicationFeature that = (ApplicationFeature)o;
        if (this.featureClass != null) {
            return this.classesAreEqual(that);
        }
        return this.idAndNameAreEqual(that);
    }

    public int hashCode() {
        int result = this.featureClass != null ? this.featureClass.hashCode() : 0;
        result = 31 * result + (this.featureId != null ? this.featureId.hashCode() : 0);
        result = 31 * result + (this.featureName != null ? this.featureName.hashCode() : 0);
        return result;
    }
}

