/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RenderedPageObjectView {
    private final transient WebDriver driver;
    private final transient long waitForTimeout;
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 50;
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderedPageObjectView.class);

    public RenderedPageObjectView(WebDriver driver, long waitForTimeout) {
        this.driver = driver;
        this.waitForTimeout = waitForTimeout;
    }

    public void waitFor(By byElementCriteria) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && !this.elementIsDisplayed(byElementCriteria)) {
            this.waitABit(50L);
        }
        this.checkThatElementAppeared(byElementCriteria);
        this.checkThatElementIsDisplayed(byElementCriteria);
    }

    public void waitForPresenceOf(By byElementCriteria) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && !this.elementIsPresent(byElementCriteria)) {
            this.waitABit(50L);
        }
        this.checkThatElementIsPresent(byElementCriteria);
    }

    private void checkThatElementIsDisplayed(By byElementCriteria) {
        if (!this.elementIsDisplayed(byElementCriteria)) {
            throw new ElementNotVisibleException("Element not displayed: " + byElementCriteria);
        }
    }

    private void checkThatElementIsPresent(By byElementCriteria) {
        if (!this.elementIsPresent(byElementCriteria)) {
            throw new ElementNotVisibleException("Element not present: " + byElementCriteria);
        }
    }

    public boolean elementIsPresent(By byElementCriteria) {
        boolean isDisplayed = true;
        try {
            List matchingElements = this.driver.findElements(byElementCriteria);
            if (matchingElements.isEmpty()) {
                return false;
            }
        }
        catch (NoSuchElementException noSuchElement) {
            LOGGER.trace("No such element " + (Object)((Object)noSuchElement));
        }
        return isDisplayed;
    }

    public boolean elementIsDisplayed(By byElementCriteria) {
        boolean isDisplayed = false;
        try {
            List matchingElements = this.driver.findElements(byElementCriteria);
            if (matchingElements.isEmpty()) {
                return false;
            }
            WebElement renderedElement = (WebElement)matchingElements.get(0);
            isDisplayed = renderedElement.isDisplayed();
        }
        catch (NoSuchElementException noSuchElement) {
            LOGGER.trace("No such element " + (Object)((Object)noSuchElement));
        }
        return isDisplayed;
    }

    private void checkThatElementAppeared(By byElementCriteria) {
        this.driver.findElement(byElementCriteria);
    }

    protected void waitABit(long timeInMilliseconds) {
        try {
            Thread.sleep(timeInMilliseconds);
        }
        catch (InterruptedException e) {
            LOGGER.error("Wait interrupted", (Throwable)e);
        }
    }

    public void waitForText(String expectedText) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && !this.containsText(expectedText)) {
            this.waitABit(50L);
        }
        if (!this.containsText(expectedText)) {
            throw new ElementNotVisibleException("Expected text was not displayed: '" + expectedText + "'");
        }
    }

    public void waitForText(WebElement element, String expectedText) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && !this.containsText(element, expectedText)) {
            this.waitABit(50L);
        }
        if (!this.containsText(element, expectedText)) {
            throw new ElementNotVisibleException("Expected text was not displayed: '" + expectedText + "'");
        }
    }

    public void waitForTitle(String expectedTitle) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && !this.titleIs(expectedTitle)) {
            this.waitABit(50L);
        }
        if (!this.titleIs(expectedTitle)) {
            throw new ElementNotVisibleException("Expected title was not displayed: '" + expectedTitle + "'");
        }
    }

    private boolean titleIs(String expectedTitle) {
        return this.driver.getTitle() != null && this.driver.getTitle().equals(expectedTitle);
    }

    public boolean containsText(String textValue) {
        String textInBody = String.format("//body[contains(.,\"%s\")]", textValue);
        List elements = this.driver.findElements(By.xpath((String)textInBody));
        return !elements.isEmpty();
    }

    public boolean containsText(WebElement element, String textValue) {
        String textInBody = String.format("//body[contains(.,\"%s\")]", textValue);
        List elements = element.findElements(By.xpath((String)textInBody));
        return !elements.isEmpty();
    }

    public void waitForTextToDisappear(String expectedText, long timeout) {
        long end = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < end && this.containsText(expectedText)) {
            this.waitABit(50L);
        }
        if (this.containsText(expectedText)) {
            throw new ElementNotVisibleException("Text was still displayed after timeout: '" + expectedText + "'");
        }
    }

    public void waitForTitleToDisappear(String expectedTitle) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && this.titleIs(expectedTitle)) {
            this.waitABit(50L);
        }
        if (this.titleIs(expectedTitle)) {
            throw new ElementNotVisibleException("Title was still displayed after timeout: '" + expectedTitle + "'");
        }
    }

    public void waitForAnyTextToAppear(String ... expectedTexts) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && !this.pageContains(expectedTexts)) {
            this.waitABit(50L);
        }
        if (!this.pageContains(expectedTexts)) {
            throw new ElementNotVisibleException("Expected text was not displayed: Was expecting any of '" + Arrays.toString(expectedTexts));
        }
    }

    public void waitForAnyTextToAppear(WebElement element, String[] expectedText) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && !this.elementContains(element, expectedText)) {
            this.waitABit(50L);
        }
        if (!this.elementContains(element, expectedText)) {
            throw new ElementNotVisibleException("Expected text was not displayed: '" + Arrays.toString(expectedText) + "'");
        }
    }

    private boolean elementContains(WebElement element, String ... expectedTexts) {
        for (String expectedText : expectedTexts) {
            if (!this.containsText(element, expectedText)) continue;
            return true;
        }
        return false;
    }

    private boolean pageContains(String ... expectedTexts) {
        for (String expectedText : expectedTexts) {
            if (!this.containsText(expectedText)) continue;
            return true;
        }
        return false;
    }

    public void waitForAllTextToAppear(String ... expectedTexts) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        List<String> requestedTexts = this.buildInitialListOfExpectedTextsFrom(expectedTexts);
        boolean allTextsFound = false;
        while (System.currentTimeMillis() < end) {
            if ((requestedTexts = this.removeAnyTextsPresentOnPageFrom(requestedTexts)).isEmpty()) {
                allTextsFound = true;
                break;
            }
            this.waitABit(50L);
        }
        if (!allTextsFound) {
            throw new ElementNotVisibleException("Expected text was not displayed: was expecting all of " + this.printableFormOf(requestedTexts));
        }
    }

    private String printableFormOf(List<String> texts) {
        return Arrays.toString(texts.toArray());
    }

    private List<String> buildInitialListOfExpectedTextsFrom(String ... expectedTexts) {
        ArrayList<String> requestedTexts = new ArrayList<String>();
        requestedTexts.addAll(Arrays.asList(expectedTexts));
        return requestedTexts;
    }

    private List<String> removeAnyTextsPresentOnPageFrom(List<String> requestedTexts) {
        ArrayList<String> updatedList = new ArrayList<String>();
        updatedList.addAll(requestedTexts);
        for (String requestedText : requestedTexts) {
            if (!this.pageContains(requestedText)) continue;
            updatedList.remove(requestedText);
        }
        return updatedList;
    }

    public void waitForElementsToDisappear(By byElementCriteria) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && this.elementIsDisplayed(byElementCriteria)) {
            this.waitABit(50L);
        }
        if (this.elementIsDisplayed(byElementCriteria)) {
            throw new ElementNotVisibleException("Element should not be displayed displayed: " + byElementCriteria);
        }
    }

    public void waitForAnyRenderedElementOf(By[] expectedElements) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        boolean renderedElementFound = false;
        while (System.currentTimeMillis() < end) {
            if (this.anyElementRenderedIn(expectedElements)) {
                renderedElementFound = true;
                break;
            }
            this.waitABit(50L);
        }
        if (!renderedElementFound) {
            throw new ElementNotVisibleException("None of the expected elements where displayed: '" + Arrays.toString(expectedElements) + "'");
        }
    }

    private boolean anyElementRenderedIn(By[] expectedElements) {
        boolean elementRendered = false;
        for (By expectedElement : expectedElements) {
            if (!this.elementIsDisplayed(expectedElement)) continue;
            elementRendered = true;
            break;
        }
        return elementRendered;
    }
}

