/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formatter {
    private final String issueTrackerUrl;
    private final Pattern issueNumberPattern = Pattern.compile("#\\d+");
    private final String issueUrlFormat = "%s%s";
    private final String issueLinkFormat = "<a href=\"%s\">%s</a>";

    public Formatter(String issueTrackerUrl) {
        this.issueTrackerUrl = issueTrackerUrl;
    }

    public List<String> issuesIn(String value) {
        Matcher matcher = this.issueNumberPattern.matcher(value);
        ArrayList<String> issues = new ArrayList<String>();
        while (matcher.find()) {
            issues.add(matcher.group());
        }
        return issues;
    }

    public String addLinks(String value) {
        String formattedValue = value;
        if (this.issueTrackerUrl != null) {
            formattedValue = this.insertIssueTrackingUrls(value);
        }
        return formattedValue;
    }

    private String insertIssueTrackingUrls(String value) {
        String formattedValue = value;
        List<String> issues = this.issuesIn(value);
        for (String issue : issues) {
            String issueUrl = String.format("%s%s", this.issueTrackerUrl, this.stripLeadingHashFrom(issue));
            String issueLink = String.format("<a href=\"%s\">%s</a>", issueUrl, issue);
            formattedValue = formattedValue.replaceAll(issue, issueLink);
        }
        return formattedValue;
    }

    private String stripLeadingHashFrom(String issue) {
        return issue.substring(1);
    }
}

