/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.xml;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;
import net.thucydides.core.model.ConcreteTestStep;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestStepGroup;
import net.thucydides.core.model.features.ApplicationFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOutcomeConverter
implements Converter {
    private static final String TITLE_FIELD = "title";
    private static final String NAME_FIELD = "name";
    private static final String ID_FIELD = "id";
    private static final String STEPS_FIELD = "steps";
    private static final String SUCCESSFUL_FIELD = "successful";
    private static final String FAILURES_FIELD = "failures";
    private static final String SKIPPED_FIELD = "skipped";
    private static final String IGNORED_FIELD = "ignored";
    private static final String PENDING_FIELD = "pending";
    private static final String RESULT_FIELD = "result";
    private static final String TEST_GROUP = "test-group";
    private static final String TEST_STEP = "test-step";
    private static final String USER_STORY = "user-story";
    private static final String FEATURE = "feature";
    private static final String REQUIREMENTS = "requirements";
    private static final String REQUIREMENT = "requirement";
    private static final String EXCEPTION = "exception";
    private static final String ERROR = "error";
    private static final String SCREENSHOT_FIELD = "screenshot";
    private static final String DESCRIPTION = "description";
    private transient String qualifier;

    public TestOutcomeConverter() {
    }

    public TestOutcomeConverter(String qualifier) {
        this();
        this.qualifier = qualifier;
    }

    public boolean canConvert(Class clazz) {
        return TestOutcome.class.isAssignableFrom(clazz);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        TestOutcome testOutcome = (TestOutcome)value;
        Preconditions.checkNotNull((Object)testOutcome, (Object)"The test run was null - WTF?");
        writer.addAttribute(TITLE_FIELD, this.titleFrom(testOutcome));
        writer.addAttribute(NAME_FIELD, this.nameFrom(testOutcome));
        writer.addAttribute(STEPS_FIELD, Integer.toString(testOutcome.countTestSteps()));
        writer.addAttribute(SUCCESSFUL_FIELD, Integer.toString(testOutcome.getSuccessCount()));
        writer.addAttribute(FAILURES_FIELD, Integer.toString(testOutcome.getFailureCount()));
        writer.addAttribute(SKIPPED_FIELD, Integer.toString(testOutcome.getSkippedCount()));
        writer.addAttribute(IGNORED_FIELD, Integer.toString(testOutcome.getIgnoredCount()));
        writer.addAttribute(PENDING_FIELD, Integer.toString(testOutcome.getPendingCount()));
        writer.addAttribute(RESULT_FIELD, testOutcome.getResult().toString());
        this.addUserStoryTo(writer, testOutcome.getUserStory());
        this.addRequirementsTo(writer, testOutcome.getTestedRequirements());
        List<TestStep> steps = testOutcome.getTestSteps();
        for (TestStep step : steps) {
            this.writeStepTo(writer, step);
        }
    }

    private String titleFrom(TestOutcome testOutcome) {
        if (this.qualifier == null) {
            return testOutcome.getTitle();
        }
        return testOutcome.getTitle() + " [" + this.humanized(this.qualifier) + "]";
    }

    private String humanized(String text) {
        return text.replaceAll("_", "/");
    }

    private String nameFrom(TestOutcome testOutcome) {
        String testRunName;
        String baseName = null;
        baseName = testOutcome.getMethodName() != null ? testOutcome.getMethodName() : testOutcome.getTitle();
        if (this.qualifier == null) {
            testRunName = baseName;
        } else {
            String qualifierWithoutSpaces = this.qualifier.replaceAll(" ", "_");
            testRunName = baseName + "_" + qualifierWithoutSpaces;
        }
        return testRunName;
    }

    private void writeStepTo(HierarchicalStreamWriter writer, TestStep step) {
        if (step instanceof TestStepGroup) {
            writer.startNode(TEST_GROUP);
            writer.addAttribute(NAME_FIELD, step.getDescription());
            this.writeResult(writer, step);
            this.writeScreenshotIfPresent(writer, step);
            List<TestStep> nestedSteps = ((TestStepGroup)step).getSteps();
            for (TestStep nestedStep : nestedSteps) {
                this.writeStepTo(writer, nestedStep);
            }
            writer.endNode();
        } else {
            ConcreteTestStep concreteStep = (ConcreteTestStep)step;
            writer.startNode(TEST_STEP);
            this.writeResult(writer, concreteStep);
            this.writeScreenshotIfPresent(writer, concreteStep);
            this.addRequirementsTo(writer, step.getTestedRequirements());
            this.writeDescription(writer, concreteStep);
            this.writeErrorForFailingTest(writer, concreteStep);
            writer.endNode();
        }
    }

    private void addUserStoryTo(HierarchicalStreamWriter writer, Story userStory) {
        if (userStory != null) {
            writer.startNode(USER_STORY);
            writer.addAttribute(ID_FIELD, userStory.getId());
            writer.addAttribute(NAME_FIELD, userStory.getName());
            if (userStory.getFeatureClass() != null) {
                this.writeFeatureNode(writer, userStory);
            }
            writer.endNode();
        }
    }

    private void writeFeatureNode(HierarchicalStreamWriter writer, Story userStory) {
        ApplicationFeature feature = ApplicationFeature.from(userStory.getFeatureClass());
        writer.startNode(FEATURE);
        writer.addAttribute(ID_FIELD, feature.getId());
        writer.addAttribute(NAME_FIELD, feature.getName());
        writer.endNode();
    }

    private void addRequirementsTo(HierarchicalStreamWriter writer, Set<String> set) {
        if (!set.isEmpty()) {
            writer.startNode(REQUIREMENTS);
            for (String requirement : set) {
                writer.startNode(REQUIREMENT);
                writer.setValue(requirement);
                writer.endNode();
            }
            writer.endNode();
        }
    }

    private void writeErrorForFailingTest(HierarchicalStreamWriter writer, ConcreteTestStep step) {
        if (step.isFailure().booleanValue()) {
            this.writeErrorMessageAndException(writer, step);
        }
    }

    private void writeErrorMessageAndException(HierarchicalStreamWriter writer, ConcreteTestStep step) {
        if (step.getErrorMessage() != null) {
            this.writeErrorMessageNode(writer, step.getErrorMessage());
            if (step.getException() != null) {
                this.writeExceptionNode(writer, step.getException());
            }
        }
    }

    private void writeExceptionNode(HierarchicalStreamWriter writer, Throwable cause) {
        writer.startNode(EXCEPTION);
        StringWriter stringWriter = new StringWriter();
        cause.printStackTrace(new PrintWriter(stringWriter));
        writer.setValue(stringWriter.toString());
        writer.endNode();
    }

    private void writeErrorMessageNode(HierarchicalStreamWriter writer, String errorMessage) {
        writer.startNode(ERROR);
        writer.setValue(errorMessage);
        writer.endNode();
    }

    private void writeScreenshotIfPresent(HierarchicalStreamWriter writer, TestStep step) {
        if (step.getScreenshot() != null) {
            writer.addAttribute(SCREENSHOT_FIELD, step.getScreenshot().getName());
        }
    }

    private void writeResult(HierarchicalStreamWriter writer, TestStep step) {
        writer.addAttribute(RESULT_FIELD, step.getResult().toString());
    }

    private void writeDescription(HierarchicalStreamWriter writer, TestStep step) {
        writer.startNode(DESCRIPTION);
        writer.setValue(step.getDescription());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TestOutcome testOutcome = new TestOutcome();
        testOutcome.setMethodName(reader.getAttribute(NAME_FIELD));
        this.readChildren(reader, testOutcome);
        return testOutcome;
    }

    private void readChildren(HierarchicalStreamReader reader, TestOutcome testOutcome) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals(TEST_STEP)) {
                this.readTestStep(reader, testOutcome);
            } else if (childNode.equals(TEST_GROUP)) {
                this.readTestGroup(reader, testOutcome);
            } else if (childNode.equals(REQUIREMENTS)) {
                this.readTestRunRequirements(reader, testOutcome);
            } else if (childNode.equals(USER_STORY)) {
                this.readUserStory(reader, testOutcome);
            }
            reader.moveUp();
        }
    }

    private void readUserStory(HierarchicalStreamReader reader, TestOutcome testOutcome) {
        String storyId = reader.getAttribute(ID_FIELD);
        String storyName = reader.getAttribute(NAME_FIELD);
        ApplicationFeature feature = null;
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals(FEATURE)) {
                feature = this.readFeature(reader);
            }
            reader.moveUp();
        }
        Story story = null;
        story = feature == null ? Story.withId(storyId, storyName) : Story.withId(storyId, storyName, feature.getId(), feature.getName());
        testOutcome.setUserStory(story);
    }

    private ApplicationFeature readFeature(HierarchicalStreamReader reader) {
        String featureId = reader.getAttribute(ID_FIELD);
        String featureName = reader.getAttribute(NAME_FIELD);
        return new ApplicationFeature(featureId, featureName);
    }

    private void readTestRunRequirements(HierarchicalStreamReader reader, TestOutcome testOutcome) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String requirement = reader.getValue();
            testOutcome.testsRequirement(requirement);
            reader.moveUp();
        }
    }

    private void readTestStepRequirements(HierarchicalStreamReader reader, TestStep step) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String requirement = reader.getValue();
            step.testsRequirement(requirement);
            reader.moveUp();
        }
    }

    private void readTestStep(HierarchicalStreamReader reader, TestOutcome testOutcome) {
        ConcreteTestStep step = new ConcreteTestStep();
        String testResultValue = reader.getAttribute(RESULT_FIELD);
        TestResult result = TestResult.valueOf(testResultValue);
        step.setResult(result);
        String screenshot = reader.getAttribute(SCREENSHOT_FIELD);
        if (screenshot != null) {
            step.setScreenshotPath(screenshot);
        }
        this.readTestStepChildren(reader, step);
        testOutcome.recordStep(step);
    }

    private void readTestGroup(HierarchicalStreamReader reader, TestOutcome testOutcome) {
        String name = reader.getAttribute(NAME_FIELD);
        String screenshot = reader.getAttribute(SCREENSHOT_FIELD);
        String testResultValue = reader.getAttribute(RESULT_FIELD);
        TestResult result = TestResult.valueOf(testResultValue);
        testOutcome.startGroup(name);
        testOutcome.getCurrentGroup().setScreenshotPath(screenshot);
        testOutcome.getCurrentGroup().setResult(result);
        this.readChildren(reader, testOutcome);
        testOutcome.endGroup();
    }

    private void readTestStepChildren(HierarchicalStreamReader reader, ConcreteTestStep step) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals(DESCRIPTION)) {
                step.setDescription(reader.getValue());
            } else if (childNode.equals(REQUIREMENTS)) {
                this.readTestStepRequirements(reader, step);
            }
            reader.moveUp();
        }
    }
}

