/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;

public final class FileResources {
    private static final int BUFFER_SIZE = 4096;
    private String resourceDirectoryRoot;

    public static FileResources from(String resourceDirectoryRoot) {
        return new FileResources(resourceDirectoryRoot);
    }

    private FileResources(String resourceDirectoryRoot) {
        this.resourceDirectoryRoot = resourceDirectoryRoot;
    }

    public String findTargetSubdirectoryFrom(String sourceResource) {
        int directoryRootStartsAt = StringUtils.lastIndexOf((String)sourceResource, (String)this.resourceDirectoryRoot);
        int relativePathStartsAt = directoryRootStartsAt + this.resourceDirectoryRoot.length() + 1;
        String relativePath = sourceResource.substring(relativePathStartsAt);
        relativePath = this.stripLeadingSeparatorFrom(relativePath);
        return this.directoryIn(relativePath);
    }

    public String stripLeadingSeparatorFrom(String path) {
        if (path.startsWith("/") || path.startsWith("\\")) {
            return path.substring(1);
        }
        return path;
    }

    public String findTargetFileFrom(String sourceResource) {
        int directoryRootStartsAt = StringUtils.lastIndexOf((String)sourceResource, (String)this.resourceDirectoryRoot);
        int relativePathStartsAt = directoryRootStartsAt + this.resourceDirectoryRoot.length() + 1;
        String relativePath = sourceResource.substring(relativePathStartsAt);
        return this.filenameIn(relativePath);
    }

    public void copyResourceTo(String sourceResource, File targetDirectory) throws IOException {
        String targetFile = this.findTargetFileFrom(sourceResource);
        String targetRelativeDirectory = this.findTargetSubdirectoryFrom(sourceResource);
        File destinationDirectory = targetDirectory;
        if (targetRelativeDirectory.length() > 0) {
            destinationDirectory = new File(targetDirectory, targetRelativeDirectory);
        }
        if (new File(sourceResource).isDirectory()) {
            File fullTargetDirectory = new File(destinationDirectory, targetFile);
            fullTargetDirectory.mkdirs();
        } else {
            this.copyFileFromClasspathToTargetDirectory(sourceResource, destinationDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileFromClasspathToTargetDirectory(String resourcePath, File targetDirectory) throws IOException {
        FileOutputStream out = null;
        InputStream in = null;
        try {
            File resourceOnClasspath = new File(resourcePath);
            in = resourceOnClasspath.exists() ? new FileInputStream(resourceOnClasspath) : this.getClass().getClassLoader().getResourceAsStream(resourcePath);
            File destinationFile = new File(targetDirectory, resourceOnClasspath.getName());
            if (destinationFile.getParent() != null) {
                new File(destinationFile.getParent()).mkdirs();
            }
            out = new FileOutputStream(destinationFile);
            this.copyData(in, out);
        }
        catch (Throwable throwable) {
            this.closeSafely(out, in);
            throw throwable;
        }
        this.closeSafely(out, in);
    }

    private void copyData(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    private void closeSafely(OutputStream out, InputStream in) throws IOException {
        if (in != null) {
            in.close();
        }
        if (out != null) {
            out.close();
        }
    }

    private String directoryIn(String path) {
        if (path.contains("/")) {
            int filenameStartsAt = StringUtils.lastIndexOf((String)path, (String)"/");
            return path.substring(0, filenameStartsAt);
        }
        if (path.contains("\\")) {
            int filenameStartsAt = StringUtils.lastIndexOf((String)path, (String)"\\");
            return path.substring(0, filenameStartsAt);
        }
        return "";
    }

    private String filenameIn(String path) {
        if (path.contains("/")) {
            int filenameStartsAt = StringUtils.lastIndexOf((String)path, (String)"/");
            return path.substring(filenameStartsAt + 1);
        }
        if (path.contains("\\")) {
            int filenameStartsAt = StringUtils.lastIndexOf((String)path, (String)"\\");
            return path.substring(filenameStartsAt + 1);
        }
        return path;
    }
}

