/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.annotations.AnnotatedFields;
import net.thucydides.core.annotations.InvalidStepsFieldException;
import net.thucydides.core.annotations.Steps;
import net.thucydides.core.steps.ScenarioSteps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepsAnnotatedField {
    private Field field;
    private static final String NO_ANNOTATED_FIELD_ERROR = "No ScenarioSteps field annotated with @Steps was found in the test case.";

    public static List<StepsAnnotatedField> findMandatoryAnnotatedFields(Class<?> clazz) {
        List<StepsAnnotatedField> annotatedFields = StepsAnnotatedField.findOptionalAnnotatedFields(clazz);
        if (annotatedFields.isEmpty()) {
            throw new InvalidStepsFieldException(NO_ANNOTATED_FIELD_ERROR);
        }
        return annotatedFields;
    }

    public static List<StepsAnnotatedField> findOptionalAnnotatedFields(Class<?> clazz) {
        ArrayList<StepsAnnotatedField> annotatedFields = new ArrayList<StepsAnnotatedField>();
        for (Field field : AnnotatedFields.of(clazz).allFields()) {
            if (!StepsAnnotatedField.fieldIsAnnotated(field)) continue;
            annotatedFields.add(new StepsAnnotatedField(field));
        }
        return annotatedFields;
    }

    private static boolean fieldIsAnnotated(Field aField) {
        Steps fieldAnnotation = StepsAnnotatedField.annotationFrom(aField);
        return fieldAnnotation != null;
    }

    private static Steps annotationFrom(Field aField) {
        Steps annotationOnField = null;
        if (StepsAnnotatedField.isFieldAnnotated(aField)) {
            annotationOnField = aField.getAnnotation(Steps.class);
        }
        return annotationOnField;
    }

    private static boolean isFieldAnnotated(Field field) {
        return StepsAnnotatedField.fieldIsAnnotatedCorrectly(field) && StepsAnnotatedField.fieldIsRightType(field);
    }

    private static boolean fieldIsRightType(Field field) {
        return ScenarioSteps.class.isAssignableFrom(field.getType());
    }

    private static boolean fieldIsAnnotatedCorrectly(Field field) {
        return field.getAnnotation(Steps.class) != null;
    }

    protected StepsAnnotatedField(Field field) {
        this.field = field;
    }

    public void setValue(Object testCase, ScenarioSteps steps) {
        try {
            this.field.setAccessible(true);
            this.field.set(testCase, steps);
        }
        catch (IllegalAccessException e) {
            throw new InvalidStepsFieldException("Could not access or set @Steps field: " + this.field, e);
        }
    }

    public boolean isInstantiated(Object testCase) {
        try {
            this.field.setAccessible(true);
            Object fieldValue = this.field.get(testCase);
            return fieldValue != null;
        }
        catch (IllegalAccessException e) {
            throw new InvalidStepsFieldException("Could not access or set @Steps field: " + this.field, e);
        }
    }

    public Class<? extends ScenarioSteps> getFieldClass() {
        return this.field.getType();
    }
}

