/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.util.List;
import java.util.Set;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverFacade
implements WebDriver,
TakesScreenshot {
    private final Class<? extends WebDriver> driverClass;
    protected WebDriver proxiedWebDriver;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverFacade.class);

    public WebDriverFacade(Class<? extends WebDriver> driverClass) {
        this.driverClass = driverClass;
    }

    public WebDriver getProxiedDriver() {
        if (this.proxiedWebDriver == null) {
            this.proxiedWebDriver = this.newProxyDriver();
            WebdriverProxyFactory.getFactory().notifyListenersOfWebdriverCreationIn(this);
        }
        this.ensureValidDriver();
        return this.proxiedWebDriver;
    }

    private void ensureValidDriver() {
        try {
            this.proxiedWebDriver.getCurrentUrl();
        }
        catch (WebDriverException e) {
            this.proxiedWebDriver.switchTo().defaultContent();
        }
    }

    public void reset() {
        if (this.proxiedWebDriver != null) {
            this.forcedQuit();
        }
        this.proxiedWebDriver = null;
    }

    private void forcedQuit() {
        try {
            this.getDriverInstance().quit();
            this.proxiedWebDriver = null;
        }
        catch (WebDriverException e) {
            LOGGER.warn("Closing a driver that was already closed", (Throwable)e);
        }
    }

    protected WebDriver newProxyDriver() {
        WebDriver newDriver = null;
        newDriver = this.usingAMockDriver() ? WebdriverProxyFactory.getFactory().getMockDriver() : this.newDriverInstance();
        return newDriver;
    }

    private WebDriver newDriverInstance() {
        WebDriver newDriver = null;
        try {
            newDriver = this.driverClass.newInstance();
        }
        catch (Exception e) {
            throw new UnsupportedDriverException("Could not instantiate " + this.driverClass, e);
        }
        return newDriver;
    }

    private boolean usingAMockDriver() {
        return WebdriverProxyFactory.getFactory().getMockDriver() != null;
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        if (this.proxyInstanciated() && this.driverCanTakeScreenshots()) {
            try {
                return (X)((TakesScreenshot)this.getProxiedDriver()).getScreenshotAs(target);
            }
            catch (WebDriverException e) {
                LOGGER.warn("Failed to take screenshot - driver closed already?", (Throwable)e);
            }
        }
        return null;
    }

    private boolean driverCanTakeScreenshots() {
        return TakesScreenshot.class.isAssignableFrom(this.getProxiedDriver().getClass());
    }

    public void get(String url) {
        this.getProxiedDriver().get(url);
    }

    public String getCurrentUrl() {
        return this.getProxiedDriver().getCurrentUrl();
    }

    public String getTitle() {
        return this.getProxiedDriver().getTitle();
    }

    public List<WebElement> findElements(By by) {
        return this.getProxiedDriver().findElements(by);
    }

    public WebElement findElement(By by) {
        return this.getProxiedDriver().findElement(by);
    }

    public String getPageSource() {
        return this.getProxiedDriver().getPageSource();
    }

    protected WebDriver getDriverInstance() {
        return this.proxiedWebDriver;
    }

    public void close() {
        if (this.proxyInstanciated()) {
            this.getDriverInstance().close();
        }
    }

    public void quit() {
        if (this.proxyInstanciated()) {
            try {
                this.getDriverInstance().quit();
            }
            catch (WebDriverException e) {
                LOGGER.warn("Error while quitting the driver - is this IE?");
            }
            this.proxiedWebDriver = null;
        }
    }

    protected boolean proxyInstanciated() {
        return this.getDriverInstance() != null;
    }

    public Set<String> getWindowHandles() {
        return this.getProxiedDriver().getWindowHandles();
    }

    public String getWindowHandle() {
        return this.getProxiedDriver().getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.getProxiedDriver().switchTo();
    }

    public WebDriver.Navigation navigate() {
        return this.getProxiedDriver().navigate();
    }

    public WebDriver.Options manage() {
        return this.getProxiedDriver().manage();
    }
}

