/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryTestResults {
    private List<TestOutcome> testOutcomes = new ArrayList<TestOutcome>();
    private final String title;
    private final Story story;

    public StoryTestResults(Story story) {
        this.title = story.getName();
        this.story = story;
    }

    public long getDuration() {
        return (Long)Lambda.sum(this.testOutcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getDuration());
    }

    public Story getStory() {
        return this.story;
    }

    public String getReportName(ReportNamer.ReportType type) {
        ReportNamer reportNamer = new ReportNamer(type);
        return reportNamer.getNormalizedTestNameFor(this.getStory());
    }

    public String getReportName() {
        return this.getReportName(ReportNamer.ReportType.ROOT);
    }

    public void recordTestRun(TestOutcome testOutcome) {
        this.testOutcomes.add(testOutcome);
    }

    public int getTotal() {
        return this.testOutcomes.size();
    }

    public int getFailureCount() {
        return Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isFailure())).size();
    }

    public int getSuccessCount() {
        return Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isSuccess())).size();
    }

    public int countStepsInSuccessfulTests() {
        List successfulTests = Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isSuccess()));
        return successfulTests.isEmpty() ? 0 : (Integer)Lambda.sum((Object)successfulTests, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getStepCount());
    }

    public int getPendingCount() {
        return Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isPending())).size();
    }

    public List<TestOutcome> getTestOutcomes() {
        return ImmutableList.copyOf(this.testOutcomes);
    }

    public String getTitle() {
        return StringUtils.capitalize((String)this.title);
    }

    public int getStepCount() {
        return (Integer)Lambda.sum((Object)Lambda.extract(this.testOutcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getTestSteps().size()));
    }

    private List<TestResult> getCurrentTestResults() {
        return Lambda.convert(this.getTestOutcomes(), (Converter)new ExtractTestResultsConverter());
    }

    public TestResult getResult() {
        TestResultList testResults = new TestResultList(this.getCurrentTestResults());
        return testResults.getOverallResult();
    }

    public boolean containsResultsFor(Story aUserStory) {
        return this.getStory().equals(aUserStory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractTestResultsConverter
    implements Converter<TestOutcome, TestResult> {
        private ExtractTestResultsConverter() {
        }

        public TestResult convert(TestOutcome step) {
            return step.getResult();
        }
    }
}

