/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import net.thucydides.core.pages.InternalClock;
import net.thucydides.core.pages.JavaScriptExecutorFacade;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class WebElementFacade {
    private final WebElement webElement;
    private final WebDriver driver;
    private final long timeoutInMilliseconds;
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 100;
    private InternalClock clock;

    public WebElementFacade(WebDriver driver, WebElement webElement, long timeoutInMilliseconds) {
        this.driver = driver;
        this.webElement = webElement;
        this.timeoutInMilliseconds = timeoutInMilliseconds;
        this.clock = new InternalClock();
    }

    public boolean isVisible() {
        try {
            return this.webElement.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean isCurrentlyVisible() {
        try {
            return this.webElement.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean isCurrentlyEnabled() {
        try {
            return this.webElement.isEnabled();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public void shouldBeVisible() {
        if (!this.isVisible()) {
            throw new AssertionError((Object)"Element should be visible");
        }
    }

    public void shouldBeCurrentlyVisible() {
        if (!this.isCurrentlyVisible()) {
            throw new AssertionError((Object)"Element should be visible");
        }
    }

    public void shouldNotBeVisible() {
        if (this.isVisible()) {
            throw new AssertionError((Object)"Element should not be visible");
        }
    }

    public void shouldNotBeCurrentlyVisible() {
        if (this.isCurrentlyVisible()) {
            throw new AssertionError((Object)"Element should not be visible");
        }
    }

    public boolean hasFocus() {
        JavaScriptExecutorFacade js = new JavaScriptExecutorFacade(this.driver);
        WebElement activeElement = (WebElement)js.executeScript("return window.document.activeElement");
        return this.webElement.equals(activeElement);
    }

    public boolean containsText(String value) {
        return this.webElement.getText().contains(value);
    }

    public void shouldContainText(String textValue) {
        if (!this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the web element", textValue);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void shouldNotContainText(String textValue) {
        if (this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the web element", textValue);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void shouldBeEnabled() {
        if (!this.isEnabled()) {
            String errorMessage = String.format("Field '%s' should be enabled", this.webElement);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public boolean isEnabled() {
        return this.webElement.isEnabled();
    }

    public void shouldNotBeEnabled() {
        if (this.isEnabled()) {
            String errorMessage = String.format("Field '%s' should not be enabled", this.webElement);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void type(String value) {
        this.webElement.clear();
        this.webElement.sendKeys(new CharSequence[]{value});
    }

    public void typeAndEnter(String value) {
        this.webElement.clear();
        this.webElement.sendKeys(new CharSequence[]{value, Keys.ENTER});
    }

    public void typeAndTab(String value) {
        this.webElement.clear();
        this.webElement.sendKeys(new CharSequence[]{value});
        this.webElement.sendKeys(new CharSequence[]{Keys.TAB});
    }

    public void selectByVisibleText(String label) {
        Select select = new Select(this.webElement);
        select.selectByVisibleText(label);
    }

    public String getSelectedVisibleTextValue() {
        Select select = new Select(this.webElement);
        return select.getFirstSelectedOption().getText();
    }

    public void selectByValue(String value) {
        Select select = new Select(this.webElement);
        select.selectByValue(value);
    }

    public String getSelectedValue() {
        Select select = new Select(this.webElement);
        return select.getFirstSelectedOption().getAttribute("value");
    }

    public void selectByIndex(int indexValue) {
        Select select = new Select(this.webElement);
        select.selectByIndex(indexValue);
    }

    public boolean isPresent() {
        try {
            return this.webElement.isDisplayed() || !this.webElement.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return e.getCause().getMessage().contains("Element is not usable");
        }
    }

    public void shouldBePresent() {
        if (!this.isPresent()) {
            String errorMessage = String.format("Field should be present", new Object[0]);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void shouldNotBePresent() {
        if (this.isPresent()) {
            String errorMessage = String.format("Field should not be present", new Object[0]);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void waitUntilVisible() {
        long end = System.currentTimeMillis() + this.timeoutInMilliseconds;
        while (System.currentTimeMillis() < end && !this.isCurrentlyVisible()) {
            this.clock.pauseFor(100L);
        }
        if (!this.isCurrentlyVisible()) {
            throw new ElementNotVisibleException("Expected element was not displayed");
        }
    }

    public void waitUntilNotVisible() {
        long end = System.currentTimeMillis() + this.timeoutInMilliseconds;
        while (System.currentTimeMillis() < end && this.isCurrentlyVisible()) {
            this.clock.pauseFor(100L);
        }
        if (this.isCurrentlyVisible()) {
            throw new ElementNotVisibleException("Expected hidden element was displayed");
        }
    }

    public String getValue() {
        return this.webElement.getAttribute("value");
    }

    public String getText() {
        return this.webElement.getText();
    }

    public void waitUntilEnabled() {
        long end = System.currentTimeMillis() + this.timeoutInMilliseconds;
        while (System.currentTimeMillis() < end && !this.isCurrentlyEnabled()) {
            this.clock.pauseFor(100L);
        }
        if (!this.isCurrentlyEnabled()) {
            throw new ElementNotVisibleException("Expected element was not enabled");
        }
    }

    public void waitUntilDisabled() {
        long end = System.currentTimeMillis() + this.timeoutInMilliseconds;
        while (System.currentTimeMillis() < end && this.isCurrentlyEnabled()) {
            this.clock.pauseFor(100L);
        }
        if (this.isCurrentlyEnabled()) {
            throw new ElementNotVisibleException("Expected disabled element was enabled");
        }
    }
}

