/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.lang.reflect.InvocationTargetException;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.DisplayedElementLocatorFactory;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebdriverInstanceFactory;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverFactory {
    private final WebdriverInstanceFactory webdriverInstanceFactory;

    public WebDriverFactory() {
        this.webdriverInstanceFactory = new WebdriverInstanceFactory();
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory) {
        this.webdriverInstanceFactory = webdriverInstanceFactory;
    }

    public WebDriver newInstanceOf(SupportedWebDriver driverType) {
        if (driverType == null) {
            throw new IllegalArgumentException("Driver type cannot be null");
        }
        return this.newWebdriverInstance(driverType.getWebdriverClass());
    }

    public static Class<? extends WebDriver> getClassFor(SupportedWebDriver driverType) {
        return driverType.getWebdriverClass();
    }

    protected WebDriver newWebdriverInstance(Class<? extends WebDriver> webdriverClass) {
        try {
            if (this.acceptUntrustedCertificatesForFirefox()) {
                return this.untrustedCertificateProfileDriver(webdriverClass);
            }
            return this.webdriverInstanceFactory.newInstanceOf(webdriverClass);
        }
        catch (Exception cause) {
            throw new UnsupportedDriverException("Could not instantiate " + webdriverClass, cause);
        }
    }

    private WebDriver untrustedCertificateProfileDriver(Class<? extends WebDriver> webdriverClass) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        FirefoxProfile profile = new FirefoxProfile();
        profile.setAssumeUntrustedCertificateIssuer(true);
        return this.webdriverInstanceFactory.newInstanceOf(webdriverClass, profile);
    }

    private boolean acceptUntrustedCertificatesForFirefox() {
        return ThucydidesSystemProperty.getBooleanValue(ThucydidesSystemProperty.UNTRUSTED_CERTIFICATES);
    }

    public static void initElementsWithAjaxSupport(Object pageObject, WebDriver driver) {
        DisplayedElementLocatorFactory finder = new DisplayedElementLocatorFactory(driver, Configuration.getElementTimeout());
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)pageObject);
    }

    public static void initElementsWithAjaxSupport(Object pageObject, WebDriver driver, int timeout) {
        DisplayedElementLocatorFactory finder = new DisplayedElementLocatorFactory(driver, timeout);
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)pageObject);
    }
}

