/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.StoryTestResults;
import net.thucydides.core.model.features.ApplicationFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureResults {
    private final ApplicationFeature feature;
    private List<StoryTestResults> storyTestResultsList;
    private ReportNamer namer;

    public FeatureResults(ApplicationFeature feature) {
        this.feature = feature;
        this.namer = new ReportNamer(ReportNamer.ReportType.HTML);
        this.storyTestResultsList = new ArrayList<StoryTestResults>();
    }

    public ApplicationFeature getFeature() {
        return this.feature;
    }

    public void recordStoryResults(StoryTestResults storyResults) {
        this.storyTestResultsList.add(storyResults);
    }

    public Integer getTotalTests() {
        return Lambda.sum((Object)Lambda.extract(this.storyTestResultsList, (Object)((StoryTestResults)Lambda.on(StoryTestResults.class)).getTotal())).intValue();
    }

    public Integer getPassingTests() {
        return Lambda.sum((Object)Lambda.extract(this.storyTestResultsList, (Object)((StoryTestResults)Lambda.on(StoryTestResults.class)).getSuccessCount())).intValue();
    }

    public Integer getFailingTests() {
        return Lambda.sum((Object)Lambda.extract(this.storyTestResultsList, (Object)((StoryTestResults)Lambda.on(StoryTestResults.class)).getFailureCount())).intValue();
    }

    public Integer getPendingTests() {
        return Lambda.sum((Object)Lambda.extract(this.storyTestResultsList, (Object)((StoryTestResults)Lambda.on(StoryTestResults.class)).getPendingCount())).intValue();
    }

    public Integer getTotalSteps() {
        return Lambda.sum((Object)Lambda.extract(this.storyTestResultsList, (Object)((StoryTestResults)Lambda.on(StoryTestResults.class)).getStepCount())).intValue();
    }

    public Integer getTotalStories() {
        return this.storyTestResultsList.size();
    }

    public List<StoryTestResults> getStoryResults() {
        return ImmutableList.copyOf(this.storyTestResultsList);
    }

    public String getStoryReportName() {
        return "stories_" + this.namer.getNormalizedTestNameFor(this.feature);
    }

    public int countStepsInSuccessfulTests() {
        if (this.storyTestResultsList.size() == 0) {
            return 0;
        }
        return (Integer)Lambda.sum(this.storyTestResultsList, (Object)((StoryTestResults)Lambda.on(StoryTestResults.class)).countStepsInSuccessfulTests());
    }
}

