/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.thucydides.core.model.Story;
import net.thucydides.core.steps.DataDrivenStep;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.TestStepResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepEventBus {
    private static ThreadLocal<StepEventBus> stepEventBusThreadLocal = new ThreadLocal();
    private List<StepListener> registeredListeners = new ArrayList<StepListener>();
    private TestStepResult resultTally;
    private Stack<String> stepStack = new Stack();
    private Stack<Boolean> webdriverSuspensions = new Stack();
    private boolean stepFailed;
    private boolean pendingTest;

    public static StepEventBus getEventBus() {
        if (stepEventBusThreadLocal.get() == null) {
            stepEventBusThreadLocal.set(new StepEventBus());
        }
        return stepEventBusThreadLocal.get();
    }

    public StepEventBus registerListener(StepListener listener) {
        this.registeredListeners.add(listener);
        return this;
    }

    public void testStarted(String testName) {
        this.clear();
        for (StepListener stepListener : this.registeredListeners) {
            stepListener.testStarted(testName);
        }
    }

    public void testSuiteStarted(Class<?> testClass) {
        for (StepListener stepListener : this.registeredListeners) {
            stepListener.testSuiteStarted(testClass);
        }
    }

    public void testSuiteStarted(Story story) {
        for (StepListener stepListener : this.registeredListeners) {
            stepListener.testSuiteStarted(story);
        }
    }

    public void clear() {
        this.stepStack.clear();
        this.clearStepFailures();
        this.currentTestIsNotPending();
        this.resultTally = new TestStepResult();
        this.webdriverSuspensions.clear();
    }

    private void currentTestIsNotPending() {
        this.pendingTest = false;
    }

    private TestStepResult getResultTally() {
        if (this.resultTally == null) {
            this.resultTally = new TestStepResult();
        }
        return this.resultTally;
    }

    public void testFinished() {
        for (StepListener stepListener : this.registeredListeners) {
            stepListener.testFinished(this.getResultTally());
        }
        this.clear();
    }

    private void pushStep(String stepName) {
        this.stepStack.push(stepName);
    }

    private void popStep() {
        this.stepStack.pop();
    }

    private void clearStepFailures() {
        this.stepFailed = false;
    }

    public boolean aStepInTheCurrentTestHasFailed() {
        return this.stepFailed;
    }

    public boolean isCurrentTestDataDriven() {
        return DataDrivenStep.inProgress();
    }

    public void stepStarted(ExecutedStepDescription executedStepDescription) {
        this.pushStep(executedStepDescription.getName());
        for (StepListener stepListener : this.registeredListeners) {
            stepListener.stepStarted(executedStepDescription);
        }
    }

    public void stepFinished() {
        this.stepDone();
        this.getResultTally().logExecutedTest();
        for (StepListener stepListener : this.registeredListeners) {
            stepListener.stepFinished();
        }
    }

    private void stepDone() {
        this.popStep();
    }

    public void stepFailed(StepFailure failure) {
        this.stepDone();
        this.getResultTally().logFailure(failure);
        for (StepListener stepListener : this.registeredListeners) {
            stepListener.stepFailed(failure);
        }
        this.stepFailed = true;
    }

    public void stepIgnored() {
        this.stepDone();
        this.getResultTally().logIgnoredTest();
        for (StepListener stepListener : this.registeredListeners) {
            stepListener.stepIgnored();
        }
    }

    public void stepPending() {
        this.stepDone();
        this.getResultTally().logIgnoredTest();
        for (StepListener stepListener : this.registeredListeners) {
            stepListener.stepPending();
        }
    }

    public void dropListener(StepListener stepListener) {
        this.registeredListeners.remove(stepListener);
    }

    public void dropAllListeners() {
        this.registeredListeners.clear();
    }

    public boolean webdriverCallsAreSuspended() {
        return this.aStepInTheCurrentTestHasFailed() || !this.webdriverSuspensions.isEmpty();
    }

    public void reenableWebdriverCalls() {
        this.webdriverSuspensions.pop();
    }

    public void temporarilySuspendWebdriverCalls() {
        this.webdriverSuspensions.push(true);
    }

    public void testFailed(Throwable cause) {
        for (StepListener stepListener : this.registeredListeners) {
            stepListener.testFailed(cause);
        }
    }

    public void testPending() {
        this.pendingTest = true;
    }

    public boolean currentTestIsPending() {
        return this.pendingTest;
    }

    public void testIgnored() {
        for (StepListener stepListener : this.registeredListeners) {
            stepListener.testIgnored();
        }
    }

    public boolean areStepsRunning() {
        return !this.stepStack.isEmpty();
    }
}

