/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formatter {
    private final Pattern issueNumberPattern = Pattern.compile("#\\d+");
    private final String issueUrlFormat;
    private final String issueLinkFormat = "<a href=\"{0}\">{1}</a>";

    public Formatter(String issueUrlFormat) {
        this.issueUrlFormat = issueUrlFormat;
    }

    public List<String> issuesIn(String value) {
        Matcher matcher = this.issueNumberPattern.matcher(value);
        ArrayList<String> issues = new ArrayList<String>();
        while (matcher.find()) {
            issues.add(matcher.group());
        }
        return issues;
    }

    public String addLinks(String value) {
        String formattedValue = value;
        if (this.issueUrlFormat != null) {
            formattedValue = this.insertIssueTrackingUrls(value);
        }
        return formattedValue;
    }

    private String insertIssueTrackingUrls(String value) {
        String formattedValue = value;
        List<String> issues = this.issuesIn(value);
        for (String issue : issues) {
            String issueUrl = MessageFormat.format(this.issueUrlFormat, this.stripLeadingHashFrom(issue));
            String issueLink = MessageFormat.format("<a href=\"{0}\">{1}</a>", issueUrl, issue);
            formattedValue = formattedValue.replaceAll(issue, issueLink);
        }
        return formattedValue;
    }

    private String stripLeadingHashFrom(String issue) {
        return issue.substring(1);
    }
}

