/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thucydides.core.model.FeatureResults;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.StoryTestResults;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.reports.json.ColorScheme;
import net.thucydides.core.reports.json.RelativeSizeColorScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONTreeNode {
    private final String id;
    private final String name;
    private final Map<String, Object> data;
    private final List<JSONTreeNode> children;
    private final ColorScheme colorScheme;

    public JSONTreeNode(String id, String name, ColorScheme colorScheme) {
        this.id = id;
        this.name = name;
        this.colorScheme = colorScheme;
        this.data = new HashMap<String, Object>();
        this.children = new ArrayList<JSONTreeNode>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public List<JSONTreeNode> getChildren() {
        return this.children;
    }

    public void addFeature(FeatureResults feature) {
        JSONTreeNode featureNode = new JSONTreeNode(feature.getFeature().getId(), feature.getFeature().getName(), this.colorScheme);
        featureNode.getData().put("$area", feature.getTotalSteps());
        featureNode.getData().put("type", "feature");
        featureNode.getData().put("$color", RelativeSizeColorScheme.rgbFormatOf(this.colorScheme.colorFor(feature)));
        featureNode.getData().put("stories", feature.getTotalStories());
        featureNode.getData().put("tests", feature.getTotalTests());
        featureNode.getData().put("passing", feature.getPassingTests());
        featureNode.getData().put("pending", feature.getPendingTests());
        featureNode.getData().put("failing", feature.getFailingTests());
        featureNode.getData().put("steps", feature.getTotalSteps());
        int progress = this.getProgressFor(feature);
        featureNode.getData().put("progress", progress);
        featureNode.children.addAll(this.getStoryNodesFor(feature));
        this.children.add(featureNode);
    }

    private int getProgressFor(FeatureResults feature) {
        if (feature.getTotalSteps() == 0) {
            return 0;
        }
        return feature.countStepsInSuccessfulTests() * 100 / feature.getTotalSteps();
    }

    private List<JSONTreeNode> getStoryNodesFor(FeatureResults feature) {
        ArrayList<JSONTreeNode> stories = new ArrayList<JSONTreeNode>();
        for (StoryTestResults storyResult : feature.getStoryResults()) {
            JSONTreeNode storyNode = new JSONTreeNode(storyResult.getStory().getId(), storyResult.getStory().getName(), this.colorScheme);
            storyNode.getData().put("$area", storyResult.getStepCount());
            storyNode.getData().put("type", "story");
            storyNode.getData().put("$color", RelativeSizeColorScheme.rgbFormatOf(this.colorScheme.colorFor(storyResult)));
            storyNode.getData().put("tests", storyResult.getTotal());
            storyNode.getData().put("passing", storyResult.getSuccessCount());
            storyNode.getData().put("pending", storyResult.getPendingCount());
            storyNode.getData().put("failing", storyResult.getFailureCount());
            storyNode.getData().put("steps", storyResult.getStepCount());
            int progress = this.getProgressFor(storyResult);
            storyNode.getData().put("progress", progress);
            storyNode.children.addAll(this.getTestOutcomeNodesFor(storyResult, this.averageTestSizeIn(feature)));
            stories.add(storyNode);
        }
        return stories;
    }

    private int getProgressFor(StoryTestResults storyResult) {
        if (storyResult.getStepCount() == 0) {
            return 0;
        }
        return storyResult.countStepsInSuccessfulTests() * 100 / storyResult.getStepCount();
    }

    private int averageTestSizeIn(FeatureResults feature) {
        int totalExecutedSteps = this.totalStepsInExecutedTestsIn(feature);
        int totalExecutedTests = this.totalExecutedTestsIn(feature);
        if (totalExecutedTests > 0) {
            return totalExecutedSteps / totalExecutedTests;
        }
        return 1;
    }

    protected int totalExecutedTestsIn(FeatureResults feature) {
        int testTally = 0;
        List<StoryTestResults> storyTestResults = feature.getStoryResults();
        for (StoryTestResults testResults : storyTestResults) {
            List<TestOutcome> outcomes = testResults.getTestOutcomes();
            for (TestOutcome outcome : outcomes) {
                if (!outcome.isFailure().booleanValue() && !outcome.isSuccess().booleanValue()) continue;
                ++testTally;
            }
        }
        return testTally;
    }

    protected int totalStepsInExecutedTestsIn(FeatureResults feature) {
        int stepTally = 0;
        List<StoryTestResults> storyTestResults = feature.getStoryResults();
        for (StoryTestResults testResults : storyTestResults) {
            List<TestOutcome> outcomes = testResults.getTestOutcomes();
            for (TestOutcome outcome : outcomes) {
                if (!outcome.isFailure().booleanValue() && !outcome.isSuccess().booleanValue()) continue;
                stepTally += outcome.getStepCount().intValue();
            }
        }
        return stepTally;
    }

    private List<JSONTreeNode> getTestOutcomeNodesFor(StoryTestResults storyTestResults, int sizeOfPendingOrSkippedTests) {
        ArrayList<JSONTreeNode> outcomes = new ArrayList<JSONTreeNode>();
        for (TestOutcome outcome : storyTestResults.getTestOutcomes()) {
            JSONTreeNode node = new JSONTreeNode(outcome.getMethodName(), outcome.getTitle(), this.colorScheme);
            int nodeArea = this.findTestArea(sizeOfPendingOrSkippedTests, outcome);
            node.getData().put("$area", nodeArea);
            node.getData().put("type", "test");
            node.getData().put("$color", RelativeSizeColorScheme.rgbFormatOf(this.colorScheme.colorFor(outcome)));
            node.getData().put("result", (Object)outcome.getResult());
            node.getData().put("steps", outcome.countTestSteps());
            node.getData().put("report", outcome.getReportName(ReportNamer.ReportType.HTML));
            outcomes.add(node);
        }
        return outcomes;
    }

    private int findTestArea(int sizeOfPendingOrSkippedTests, TestOutcome outcome) {
        int nodeArea = this.testWasSkipped(outcome) ? sizeOfPendingOrSkippedTests : outcome.countTestSteps();
        return nodeArea;
    }

    private boolean testWasSkipped(TestOutcome outcome) {
        return outcome.isPending() != false || outcome.getResult() == TestResult.IGNORED || outcome.getResult() == TestResult.SKIPPED;
    }
}

