/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.TestStepResult;
import org.openqa.selenium.firefox.FirefoxDriver;

public class ConsoleStepListener
extends BaseStepListener {
    private final StringBuffer buffer = new StringBuffer();
    int currentIndent = 0;

    public ConsoleStepListener() {
        super(FirefoxDriver.class, null);
    }

    public String toString() {
        return this.buffer.toString();
    }

    private void push() {
        ++this.currentIndent;
    }

    private void pop() {
        --this.currentIndent;
    }

    public void testStarted(String description) {
        this.buffer.append("TEST " + description).append("\n");
        this.push();
    }

    public void testFinished(TestStepResult result) {
        this.pop();
        this.buffer.append("TEST DONE").append("\n");
    }

    public void stepStarted(ExecutedStepDescription description) {
        this.writeIndent(this.buffer);
        this.buffer.append(description.getName()).append("\n");
        this.push();
    }

    private void writeIndent(StringBuffer buffer) {
        for (int i = 0; i < this.currentIndent; ++i) {
            buffer.append("-");
        }
    }

    public void stepFinished() {
        this.pop();
        this.writeIndent(this.buffer);
        this.buffer.append("--> STEP DONE").append("\n");
    }

    public void stepFailed(StepFailure failure) {
        this.pop();
        this.writeIndent(this.buffer);
        this.buffer.append("--> STEP FAILED").append("\n");
    }

    public void stepIgnored() {
        this.pop();
        this.writeIndent(this.buffer);
        this.buffer.append("--> STEP IGNORED").append("\n");
    }

    public void stepPending() {
        this.pop();
        this.writeIndent(this.buffer);
        this.buffer.append("--> STEP PENDING").append("\n");
    }

    public void testFailed(Throwable cause) {
        this.buffer.append("--> TEST FAILED").append("\n");
    }

    public void testIgnored() {
        this.buffer.append("--> TEST IGNORED").append("\n");
    }
}

