/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.util.StringUtils;

public final class NameConverter {
    private static final Pattern CAMEL_CASE_MATCHER_PATTERN = Pattern.compile("\\p{Lu}");

    private NameConverter() {
    }

    public static String humanize(String name) {
        if (name == null || name.trim().length() == 0) {
            return "";
        }
        if (name.contains(" ") && !NameConverter.thereAreParametersIn(name)) {
            return name;
        }
        if (NameConverter.thereAreParametersIn(name)) {
            return NameConverter.humanizeNameWithParameters(name);
        }
        String noUnderscores = name.replaceAll("_", " ");
        String splitCamelCase = NameConverter.splitCamelCase(noUnderscores);
        return StringUtils.capitalizeFirstLetter((String)splitCamelCase.toLowerCase(Locale.getDefault()));
    }

    private static String humanizeNameWithParameters(String name) {
        int parametersStartAt = name.indexOf(": ");
        String bareName = name.substring(0, parametersStartAt);
        String humanizedBareName = NameConverter.humanize(bareName);
        String parameters = name.substring(parametersStartAt);
        return humanizedBareName + parameters;
    }

    private static boolean thereAreParametersIn(String name) {
        return name.contains(": ");
    }

    public static String splitCamelCase(String name) {
        Matcher m = CAMEL_CASE_MATCHER_PATTERN.matcher(name);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, " " + m.group());
        }
        m.appendTail(sb);
        return sb.toString().trim();
    }

    public static String withNoArguments(String methodName) {
        return NameConverter.stripArgumentsFrom(NameConverter.stripIndexesFrom(methodName));
    }

    public static String stripArgumentsFrom(String methodName) {
        if (methodName == null) {
            return null;
        }
        int firstArgument = methodName.indexOf(58);
        if (firstArgument > 0) {
            return methodName.substring(0, firstArgument);
        }
        return methodName;
    }

    public static String stripIndexesFrom(String methodName) {
        if (methodName == null) {
            return null;
        }
        int firstBracket = methodName.indexOf(91);
        if (firstBracket > 0) {
            return methodName.substring(0, firstBracket);
        }
        return methodName;
    }

    public static String underscore(String name) {
        if (name != null) {
            return name.replaceAll(" ", "_").replaceAll("<", "_").replaceAll(">", "_").replaceAll("'", "_").replaceAll(",", "_").replaceAll(":", "_").replaceAll("/", "_").replaceAll("\"", "_").replaceAll("=", "_").toLowerCase(Locale.getDefault()).trim();
        }
        return "";
    }
}

