/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ThucydidesWebDriverEventListener;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebDriverFactory;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebdriverProxyFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static ThreadLocal<WebdriverProxyFactory> factory = new ThreadLocal();
    private static List<ThucydidesWebDriverEventListener> eventListeners = new ArrayList<ThucydidesWebDriverEventListener>();
    private WebDriverFactory webDriverFactory = new WebDriverFactory();
    private WebDriver mockDriver;

    private WebdriverProxyFactory() {
    }

    public static WebdriverProxyFactory getFactory() {
        if (factory.get() == null) {
            factory.set(new WebdriverProxyFactory());
        }
        return factory.get();
    }

    public WebDriver proxyFor(Class<? extends WebDriver> driverClass) {
        return this.proxyFor(driverClass, new WebDriverFactory());
    }

    public WebDriver proxyFor(Class<? extends WebDriver> driverClass, WebDriverFactory webDriverFactory) {
        if (this.mockDriver != null) {
            return this.mockDriver;
        }
        return new WebDriverFacade(driverClass, webDriverFactory);
    }

    public void registerListener(ThucydidesWebDriverEventListener eventListener) {
        eventListeners.add(eventListener);
    }

    public void notifyListenersOfWebdriverCreationIn(WebDriverFacade webDriverFacade) {
        for (ThucydidesWebDriverEventListener listener : eventListeners) {
            listener.driverCreatedIn(webDriverFacade);
        }
    }

    public WebDriver proxyDriver() {
        Class<? extends WebDriver> driverClass = WebDriverFactory.getClassFor(Configuration.getDriverType());
        return this.proxyFor(driverClass, this.webDriverFactory);
    }

    public static void resetDriver(WebDriver driver) {
        if (driver instanceof WebDriverFacade) {
            ((WebDriverFacade)driver).reset();
        }
    }

    public void useMockDriver(WebDriver mockDriver) {
        this.mockDriver = mockDriver;
    }

    public void clearMockDriver() {
        this.mockDriver = null;
    }
}

