/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.FeatureResults;
import net.thucydides.core.model.NumericalFormatter;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.StoryTestResults;
import net.thucydides.core.model.UserStoriesResultSet;
import net.thucydides.core.model.features.FeatureLoader;
import net.thucydides.core.model.userstories.UserStoryLoader;
import net.thucydides.core.reports.ThucydidesReportData;
import net.thucydides.core.reports.UserStoryTestReporter;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.html.HtmlReporter;
import net.thucydides.core.reports.json.JSONProgressResultTree;
import net.thucydides.core.reports.json.JSONResultTree;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlAggregateStoryReporter
extends HtmlReporter
implements UserStoryTestReporter {
    private static final String DEFAULT_USER_STORY_TEMPLATE = "velocity/user-story.vm";
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlAggregateStoryReporter.class);
    private static final String STORIES_TEMPLATE_PATH = "velocity/stories.vm";
    private static final String FEATURES_TEMPLATE_PATH = "velocity/features.vm";
    private static final String COVERAGE_DATA_TEMPLATE_PATH = "velocity/coverage.vm";
    private static final String PROGRESS_DATA_TEMPLATE_PATH = "velocity/progress.vm";
    private static final String HOME_TEMPLATE_PATH = "velocity/index.vm";
    private static final String DASHBOARD_TEMPLATE_PATH = "velocity/dashboard.vm";
    private FeatureLoader featureLoader;
    private UserStoryLoader storyLoader = new UserStoryLoader();
    private String issueTrackerUrl;

    public HtmlAggregateStoryReporter() {
        this.featureLoader = new FeatureLoader();
    }

    @Override
    public File generateReportFor(StoryTestResults storyTestResults) throws IOException {
        LOGGER.info("Generating report for user story " + storyTestResults.getTitle() + " to " + this.getOutputDirectory());
        VelocityContext context = new VelocityContext();
        context.put("story", (Object)storyTestResults);
        this.addFormattersToContext(context);
        String htmlContents = this.mergeTemplate(DEFAULT_USER_STORY_TEMPLATE).usingContext(context);
        this.copyResourcesToOutputDirectory();
        String reportFilename = storyTestResults.getReportName(ReportNamer.ReportType.HTML);
        return this.writeReportToOutputDirectory(reportFilename, htmlContents);
    }

    private void addFormattersToContext(VelocityContext context) {
        Formatter formatter = new Formatter(ThucydidesSystemProperty.getValue(ThucydidesSystemProperty.ISSUE_TRACKER_URL));
        context.put("formatter", (Object)formatter);
        context.put("formatted", (Object)new NumericalFormatter());
    }

    @Override
    public ThucydidesReportData generateReportsForStoriesFrom(File sourceDirectory) throws IOException {
        List<StoryTestResults> storyResults = this.loadStoryResultsFrom(sourceDirectory);
        List<FeatureResults> featureResults = this.loadFeatureResultsFrom(sourceDirectory);
        this.copyResourcesToOutputDirectory();
        for (StoryTestResults storyTestResults : storyResults) {
            this.generateReportFor(storyTestResults);
        }
        this.generateAggregateReportFor(storyResults, featureResults);
        return new ThucydidesReportData(featureResults, storyResults);
    }

    private List<StoryTestResults> loadStoryResultsFrom(File sourceDirectory) throws IOException {
        return this.storyLoader.loadFrom(sourceDirectory);
    }

    private List<FeatureResults> loadFeatureResultsFrom(File sourceDirectory) throws IOException {
        return this.featureLoader.loadFrom(sourceDirectory);
    }

    private void generateAggregateReportFor(List<StoryTestResults> storyResults, List<FeatureResults> featureResults) throws IOException {
        LOGGER.info("Generating summary report for user stories to " + this.getOutputDirectory());
        this.copyResourcesToOutputDirectory();
        this.generateStoriesReport(storyResults);
        this.generateFeatureReport(featureResults);
        this.generateReportHomePage(storyResults, featureResults);
    }

    private void generateFeatureReport(List<FeatureResults> featureResults) throws IOException {
        VelocityContext context = new VelocityContext();
        this.addFormattersToContext(context);
        context.put("features", featureResults);
        String htmlContents = this.mergeTemplate(FEATURES_TEMPLATE_PATH).usingContext(context);
        this.writeReportToOutputDirectory("features.html", htmlContents);
        for (FeatureResults feature : featureResults) {
            this.generateStoryReportForFeature(feature);
        }
    }

    private void generateStoryReportForFeature(FeatureResults feature) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("stories", feature.getStoryResults());
        context.put("storyContext", (Object)feature.getFeature().getName());
        this.addFormattersToContext(context);
        LOGGER.debug("Generating stories page");
        String htmlContents = this.mergeTemplate(STORIES_TEMPLATE_PATH).usingContext(context);
        LOGGER.debug("Writing stories page");
        String filename = feature.getStoryReportName();
        this.writeReportToOutputDirectory(filename, htmlContents);
    }

    private void generateStoriesReport(List<StoryTestResults> storyResults) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("stories", storyResults);
        context.put("storyContext", (Object)"All stories");
        this.addFormattersToContext(context);
        String htmlContents = this.mergeTemplate(STORIES_TEMPLATE_PATH).usingContext(context);
        LOGGER.debug("Writing stories page");
        this.writeReportToOutputDirectory("stories.html", htmlContents);
    }

    private void generateReportHomePage(List<StoryTestResults> storyResults, List<FeatureResults> featureResults) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("stories", (Object)new UserStoriesResultSet(storyResults));
        context.put("features", featureResults);
        this.addFormattersToContext(context);
        LOGGER.debug("Generating report pages");
        this.generateReportPage(context, HOME_TEMPLATE_PATH, "index.html");
        this.generateReportPage(context, DASHBOARD_TEMPLATE_PATH, "dashboard.html");
        LOGGER.debug("Generating coverage data");
        this.generateCoverageData(featureResults);
        this.generateProgressData(featureResults);
    }

    private void generateReportPage(VelocityContext context, String template, String outputFile) throws IOException {
        String htmlContents = this.mergeTemplate(template).usingContext(context);
        this.writeReportToOutputDirectory(outputFile, htmlContents);
    }

    private void generateCoverageData(List<FeatureResults> featureResults) throws IOException {
        VelocityContext context = new VelocityContext();
        JSONResultTree resultTree = new JSONResultTree();
        for (FeatureResults feature : featureResults) {
            resultTree.addFeature(feature);
        }
        context.put("coverageData", (Object)resultTree.toJSON());
        this.addFormattersToContext(context);
        String javascriptCoverageData = this.mergeTemplate(COVERAGE_DATA_TEMPLATE_PATH).usingContext(context);
        this.writeReportToOutputDirectory("coverage.js", javascriptCoverageData);
    }

    private void generateProgressData(List<FeatureResults> featureResults) throws IOException {
        VelocityContext context = new VelocityContext();
        JSONProgressResultTree resultTree = new JSONProgressResultTree();
        for (FeatureResults feature : featureResults) {
            resultTree.addFeature(feature);
        }
        context.put("progressData", (Object)resultTree.toJSON());
        this.addFormattersToContext(context);
        String javascriptCoverageData = this.mergeTemplate(PROGRESS_DATA_TEMPLATE_PATH).usingContext(context);
        this.writeReportToOutputDirectory("progress.js", javascriptCoverageData);
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        this.issueTrackerUrl = issueTrackerUrl;
        if (issueTrackerUrl != null) {
            ThucydidesSystemProperty.setValue(ThucydidesSystemProperty.ISSUE_TRACKER_URL, issueTrackerUrl);
        }
    }
}

