/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.pages.SystemClock;
import net.thucydides.core.screenshots.Photographer;
import net.thucydides.core.screenshots.ScreenshotException;
import net.thucydides.core.steps.AnnotatedStepDescription;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.TestStepResult;
import net.thucydides.core.util.NameConverter;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseStepListener
implements StepListener {
    private final List<TestOutcome> testOutcomes;
    private final Stack<TestStep> currentStepStack;
    private final Stack<TestStep> currentGroupStack;
    private final SystemClock clock;
    private Class<?> testSuite;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseStepListener.class);
    private WebDriver driver;
    private File outputDirectory;
    private WebdriverProxyFactory proxyFactory = WebdriverProxyFactory.getFactory();
    private Story testedStory;

    private BaseStepListener(File outputDirectory) {
        this.testOutcomes = new ArrayList<TestOutcome>();
        this.currentStepStack = new Stack();
        this.currentGroupStack = new Stack();
        this.outputDirectory = outputDirectory;
        this.clock = (SystemClock)Injectors.getInjector().getInstance(SystemClock.class);
    }

    public BaseStepListener(Class<? extends WebDriver> driverClass, File outputDirectory) {
        this(outputDirectory);
        this.driver = this.getProxyFactory().proxyFor(driverClass);
    }

    public BaseStepListener(File outputDirectory, Pages pages) {
        this(outputDirectory);
        if (pages != null) {
            this.setDriverUsingPagesDriverIfDefined(pages);
        } else {
            this.createNewDriver();
        }
    }

    private void createNewDriver() {
        this.setDriver(this.getProxyFactory().proxyDriver());
    }

    private void setDriverUsingPagesDriverIfDefined(Pages pages) {
        if (pages.getDriver() != null) {
            this.setDriver(pages.getDriver());
        } else {
            this.createNewDriver();
            pages.setDriver(this.getDriver());
            pages.notifyWhenDriverOpens();
        }
    }

    protected WebdriverProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    protected TestOutcome getCurrentTestOutcome() {
        Preconditions.checkState((!this.testOutcomes.isEmpty() ? 1 : 0) != 0);
        return this.testOutcomes.get(this.testOutcomes.size() - 1);
    }

    protected SystemClock getClock() {
        return this.clock;
    }

    @Override
    public void testSuiteStarted(Class<?> startedTestSuite) {
        LOGGER.debug("testSuiteStarted for " + startedTestSuite);
        this.testSuite = startedTestSuite;
        this.testedStory = this.findStoryFrom(startedTestSuite);
    }

    @Override
    public void testSuiteStarted(Story story) {
        this.testSuite = null;
        this.testedStory = story;
    }

    private Story findStoryFrom(Class<?> testClass) {
        if (this.storyIsDefinedIn(testClass)) {
            return this.storyFrom(testClass);
        }
        return Story.from(testClass);
    }

    private Story storyFrom(Class<?> testClass) {
        Class<?> testedStoryClass = Story.testedInTestCase(testClass);
        if (testedStoryClass != null) {
            return Story.from(testedStoryClass);
        }
        return null;
    }

    private boolean storyIsDefinedIn(Class<?> testClass) {
        return this.storyFrom(testClass) != null;
    }

    @Override
    public void testStarted(String testMethod) {
        LOGGER.debug("test started: " + testMethod);
        this.testOutcomes.add(TestOutcome.forTestInStory(testMethod, this.testSuite, this.testedStory));
        this.setAnnotatedResult(testMethod);
    }

    private void setAnnotatedResult(String testMethod) {
        if (TestAnnotations.forClass(this.testSuite).isIgnored(testMethod)) {
            this.getCurrentTestOutcome().setAnnotatedResult(TestResult.IGNORED);
        }
        if (TestAnnotations.forClass(this.testSuite).isPending(testMethod)) {
            this.getCurrentTestOutcome().setAnnotatedResult(TestResult.PENDING);
        }
    }

    @Override
    public void testFinished(TestStepResult result) {
        this.currentStepStack.clear();
    }

    @Override
    public void stepStarted(ExecutedStepDescription description) {
        LOGGER.debug("step started: " + description);
        String stepName = AnnotatedStepDescription.from(description).getName();
        TestStep step = new TestStep(stepName);
        this.startNewGroupIfNested();
        this.setDefaultResultFromAnnotations(step, description);
        this.currentStepStack.push(step);
        this.getCurrentTestOutcome().recordStep(step);
    }

    private void setDefaultResultFromAnnotations(TestStep step, ExecutedStepDescription description) {
        if (TestAnnotations.isPending(description.getTestMethod())) {
            step.setResult(TestResult.PENDING);
        }
        if (TestAnnotations.isIgnored(description.getTestMethod())) {
            step.setResult(TestResult.SKIPPED);
        }
    }

    private void startNewGroupIfNested() {
        if (this.thereAreUnfinishedSteps() && this.getCurrentStep() != this.getCurrentGroup()) {
            this.startNewGroup();
        }
    }

    private void startNewGroup() {
        this.getCurrentTestOutcome().startGroup();
        this.currentGroupStack.push(this.getCurrentStep());
    }

    private TestStep getCurrentStep() {
        return this.currentStepStack.peek();
    }

    private TestStep getCurrentGroup() {
        if (this.currentGroupStack.isEmpty()) {
            return null;
        }
        return this.currentGroupStack.peek();
    }

    private boolean thereAreUnfinishedSteps() {
        return !this.currentStepStack.isEmpty();
    }

    @Override
    public void stepFinished() {
        LOGGER.debug("step finished");
        this.takeScreenshotFor(TestResult.SUCCESS);
        this.currentStepDone();
        this.markCurrentStepAs(TestResult.SUCCESS);
        this.pauseIfRequired();
    }

    private void finishGroup() {
        this.currentGroupStack.pop();
        this.getCurrentTestOutcome().endGroup();
    }

    private void pauseIfRequired() {
        int delay = Configuration.getStepDelay();
        if (delay > 0) {
            this.getClock().pauseFor(delay);
        }
    }

    private void markCurrentStepAs(TestResult result) {
        this.getCurrentTestOutcome().getCurrentStep().setResult(result);
    }

    @Override
    public void stepFailed(StepFailure failure) {
        LOGGER.debug("step failed: " + failure);
        this.takeScreenshotFor(TestResult.FAILURE);
        this.getCurrentTestOutcome().setTestFailureCause(failure.getException());
        this.markCurrentStepAs(TestResult.FAILURE);
        this.recordFailureDetailsInFailingTestStep(failure);
        this.currentStepDone();
    }

    private void recordFailureDetailsInFailingTestStep(StepFailure failure) {
        this.getCurrentStep().failedWith(failure.getMessage(), failure.getException());
    }

    @Override
    public void stepIgnored() {
        LOGGER.debug("step ignored");
        if (this.aStepHasFailed()) {
            this.markCurrentStepAs(TestResult.SKIPPED);
            this.currentStepDone();
        } else {
            this.markCurrentStepAs(TestResult.IGNORED);
            this.currentStepDone();
        }
    }

    @Override
    public void stepPending() {
        LOGGER.debug("step pending");
        this.markCurrentStepAs(TestResult.PENDING);
        this.currentStepDone();
    }

    private void currentStepDone() {
        TestStep finishedStep = this.currentStepStack.pop();
        if (finishedStep == this.getCurrentGroup()) {
            this.finishGroup();
        }
    }

    private boolean currentStepExists() {
        return !this.currentStepStack.isEmpty();
    }

    private void takeScreenshotFor(TestResult result) {
        if (this.currentStepExists() && this.shouldTakeScreenshotFor(result)) {
            try {
                String stepDescription = this.getCurrentTestOutcome().getCurrentStep().getDescription();
                File screenshot = this.grabScreenshotFileFor(stepDescription);
                this.getCurrentStep().setScreenshot(screenshot);
                if (screenshot != null) {
                    File sourcecode = this.getPhotographer().getMatchingSourceCodeFor(screenshot);
                    this.getCurrentStep().setHtmlSource(sourcecode);
                }
            }
            catch (ScreenshotException e) {
                LOGGER.warn("Failed to take screenshot", (Throwable)e);
            }
        }
    }

    private File grabScreenshotFileFor(String testName) {
        String snapshotName = NameConverter.underscore(testName);
        return this.getPhotographer().takeScreenshot(snapshotName);
    }

    public Photographer getPhotographer() {
        return new Photographer(this.driver, this.outputDirectory);
    }

    private boolean shouldTakeScreenshotFor(TestResult result) {
        String onlySaveFailures = System.getProperty(ThucydidesSystemProperty.ONLY_SAVE_FAILING_SCREENSHOTS.getPropertyName(), "false");
        Boolean onlySaveFailureScreenshots = Boolean.valueOf(onlySaveFailures);
        return onlySaveFailureScreenshots == false || result == TestResult.FAILURE;
    }

    @Override
    public List<TestOutcome> getTestOutcomes() {
        return ImmutableList.copyOf(this.testOutcomes);
    }

    @Override
    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    @Override
    public boolean aStepHasFailed() {
        return !this.getTestOutcomes().isEmpty() && this.getCurrentTestOutcome().getTestFailureCause() != null;
    }

    @Override
    public Throwable getTestFailureCause() {
        return this.getCurrentTestOutcome().getTestFailureCause();
    }

    @Override
    public void testFailed(Throwable cause) {
        this.getCurrentTestOutcome().setTestFailureCause(cause);
    }

    @Override
    public void testIgnored() {
        this.getCurrentTestOutcome().setAnnotatedResult(TestResult.IGNORED);
    }
}

