/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.DisplayedElementLocatorFactory;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebdriverInstanceFactory;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverFactory {
    private final WebdriverInstanceFactory webdriverInstanceFactory;

    public WebDriverFactory() {
        this.webdriverInstanceFactory = new WebdriverInstanceFactory();
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory) {
        this.webdriverInstanceFactory = webdriverInstanceFactory;
    }

    public WebDriver newInstanceOf(SupportedWebDriver driverType) {
        if (driverType == null) {
            throw new IllegalArgumentException("Driver type cannot be null");
        }
        return this.newWebdriverInstance(driverType.getWebdriverClass());
    }

    public static Class<? extends WebDriver> getClassFor(SupportedWebDriver driverType) {
        return driverType.getWebdriverClass();
    }

    protected WebDriver newWebdriverInstance(Class<? extends WebDriver> driverClass) {
        try {
            if (this.isAFirefoxDriver(driverClass)) {
                return this.webdriverInstanceFactory.newInstanceOf(driverClass, this.buildFirefoxProfile());
            }
            return this.webdriverInstanceFactory.newInstanceOf(driverClass);
        }
        catch (Exception cause) {
            throw new UnsupportedDriverException("Could not instantiate " + driverClass, cause);
        }
    }

    private boolean isAFirefoxDriver(Class<? extends WebDriver> driverClass) {
        return FirefoxDriver.class.isAssignableFrom(driverClass);
    }

    protected FirefoxProfile createNewFirefoxProfile() {
        return new FirefoxProfile();
    }

    private FirefoxProfile buildFirefoxProfile() {
        FirefoxProfile profile = this.createNewFirefoxProfile();
        if (this.dontAssumeUntrustedCertificateIssuer()) {
            profile.setAssumeUntrustedCertificateIssuer(false);
        }
        return profile;
    }

    private boolean dontAssumeUntrustedCertificateIssuer() {
        return !ThucydidesSystemProperty.getBooleanValue(ThucydidesSystemProperty.ASSUME_UNTRUSTED_CERTIFICATE_ISSUER, true);
    }

    public static void initElementsWithAjaxSupport(Object pageObject, WebDriver driver) {
        DisplayedElementLocatorFactory finder = new DisplayedElementLocatorFactory(driver, Configuration.getElementTimeout());
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)pageObject);
    }

    public static void initElementsWithAjaxSupport(Object pageObject, WebDriver driver, int timeout) {
        DisplayedElementLocatorFactory finder = new DisplayedElementLocatorFactory(driver, timeout);
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)pageObject);
    }
}

