/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import net.thucydides.core.annotations.Feature;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.util.EqualsUtils;
import net.thucydides.core.util.NameConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Story {
    private final Class<?> userStoryClass;
    private final String qualifiedStoryClassName;
    private final String storyName;
    private final String qualifiedFeatureClassName;
    private final String featureName;

    protected Story(Class<?> userStoryClass) {
        this.userStoryClass = userStoryClass;
        this.qualifiedStoryClassName = userStoryClass.getCanonicalName();
        this.storyName = NameConverter.humanize(this.getUserStoryClass().getSimpleName());
        this.qualifiedFeatureClassName = this.findFeatureClassName();
        this.featureName = this.findFeatureName();
    }

    private String findFeatureClassName() {
        if (this.getFeatureClass() != null) {
            return this.getFeatureClass().getCanonicalName();
        }
        return null;
    }

    private String findFeatureName() {
        if (this.getFeatureClass() != null) {
            return ApplicationFeature.from(this.getFeatureClass()).getName();
        }
        return null;
    }

    protected Story(String qualifiedStoryClassName, String storyName, String qualifiedFeatureClassName, String featureName) {
        this.userStoryClass = null;
        this.qualifiedStoryClassName = qualifiedStoryClassName;
        this.storyName = storyName;
        this.qualifiedFeatureClassName = qualifiedFeatureClassName;
        this.featureName = featureName;
    }

    public String getId() {
        return this.qualifiedStoryClassName;
    }

    public static Story from(Class<?> userStoryClass) {
        return new Story(userStoryClass);
    }

    public static Story withId(String storyId, String storyName) {
        return new Story(storyId, storyName, null, null);
    }

    public static Story withId(String storyId, String storyName, String featureClassName, String featureName) {
        return new Story(storyId, storyName, featureClassName, featureName);
    }

    public int hashCode() {
        return this.nullSafeHashCodeOf(this.qualifiedStoryClassName);
    }

    private int nullSafeHashCodeOf(String value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Story that = (Story)obj;
        return EqualsUtils.areEqual(this.qualifiedStoryClassName, that.qualifiedStoryClassName);
    }

    public Class<?> getUserStoryClass() {
        return this.userStoryClass;
    }

    public Class<?> getFeatureClass() {
        Class<?> enclosingClass;
        if (this.userStoryClass != null && this.isAFeature(enclosingClass = this.userStoryClass.getEnclosingClass())) {
            return enclosingClass;
        }
        return null;
    }

    private boolean isAFeature(Class<?> enclosingClass) {
        return enclosingClass != null && enclosingClass.getAnnotation(Feature.class) != null;
    }

    public static Class<?> testedInTestCase(Class<?> testClass) {
        net.thucydides.core.annotations.Story story = testClass.getAnnotation(net.thucydides.core.annotations.Story.class);
        if (story != null) {
            return story.value();
        }
        return null;
    }

    public String getName() {
        return this.storyName;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getReportName(ReportNamer.ReportType type) {
        ReportNamer reportNamer = new ReportNamer(type);
        return reportNamer.getNormalizedTestNameFor(this);
    }

    public String getReportName() {
        return this.getReportName(ReportNamer.ReportType.ROOT);
    }

    public String getFeatureId() {
        return this.qualifiedFeatureClassName;
    }

    public ApplicationFeature getFeature() {
        if (this.getFeatureClass() != null) {
            return ApplicationFeature.from(this.getFeatureClass());
        }
        if (this.getFeatureId() != null) {
            return new ApplicationFeature(this.getFeatureId(), this.getFeatureName());
        }
        return null;
    }
}

